/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class LootUtils {
    public static Map<String, LootPool> mapPools(List<LootPool> pools) {
        return ImmutableMap.copyOf(pools.stream().collect(Collectors.toMap(LootPool::getName, p -> p)));
    }

    public static List<LootPool> getPools(LootTable table) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"field_186466_c");
    }

    public static List<LootEntry> getEntries(LootPool pool) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186453_a");
    }

    public static List<ILootCondition> getConditions(LootPool pool) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186454_b");
    }

    @Nullable
    public static ItemStack getItemContext(LootContext ctx) {
        ItemStack stack = (ItemStack)ctx.func_216031_c(LootParameters.field_216289_i);
        if (stack == null) {
            Entity killer = (Entity)ctx.func_216031_c(LootParameters.field_216284_d);
            if (killer == null) {
                killer = (Entity)ctx.func_216031_c(LootParameters.field_216285_e);
            }
            if (killer instanceof LivingEntity) {
                stack = ((LivingEntity)killer).func_184614_ca();
            }
        }
        return stack;
    }
}

