/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.bookshelf.crafting.block.IBlockResolver;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class BlockTagResolver
implements IBlockResolver {
    private final ResourceLocation tagId;

    public BlockTagResolver(ResourceLocation tagId) {
        this.tagId = tagId;
    }

    @Override
    public Collection<Block> resolveBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Tag tag = BlockTags.func_199896_a().func_199910_a(this.tagId);
        if (tag != null) {
            blocks.addAll(tag.func_199885_a());
        }
        return blocks;
    }

    @Override
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.getTypeId().toString());
        jsonObject.addProperty("tag", this.tagId.toString());
        return jsonObject;
    }

    @Override
    public void serialize(PacketBuffer buffer) {
        buffer.func_180714_a(this.getTypeId().toString());
        buffer.func_192572_a(this.tagId);
    }

    @Override
    public ResourceLocation getTypeId() {
        return BlockIngredient.TYPE_BLOCK_TAG;
    }

    public static BlockTagResolver deserialize(JsonObject json) {
        ResourceLocation tagId = ResourceLocation.func_208304_a((String)json.get("tag").getAsString());
        return new BlockTagResolver(tagId);
    }

    public static BlockTagResolver deserialize(PacketBuffer buffer) {
        ResourceLocation tagId = buffer.func_192575_l();
        return new BlockTagResolver(tagId);
    }
}

