/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.tools;

import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public final class MathUtils {
    public static final int B1_BYTE_MASK = 255;
    public static final int B2_BYTE_MASK = 65535;
    public static final int B3_BYTE_MASK = 0xFFFFFF;
    public static final long B5_BYTE_MASK = -1L;

    private MathUtils() {
    }

    public static short additiveInverse(short num) {
        return -num;
    }

    public static long posToLong(BlockPos pos) {
        long res = (long)(pos.func_177958_n() & 0xFFFF) << 24;
        res |= (long)((pos.func_177956_o() & 0xFF) << 16);
        return res |= (long)(pos.func_177952_p() & 0xFFFF);
    }

    public static BlockPos posFromLong(long serialized) {
        int x = (int)(serialized >> 24 & 0xFFFFL);
        int y = (int)(serialized >> 16 & 0xFFL);
        int z = (int)(serialized & 0xFFFFL);
        return new BlockPos(x, y, z);
    }

    public static long includeStateId(long serialized, int id) {
        return serialized | (long)(id & 0xFFFFFF) << 40;
    }

    public static int readStateId(long serialized) {
        return (int)(serialized >> 40 & 0xFFFFFFL);
    }

    public static long readSerializedPos(long serialized) {
        return serialized & 0xFFFFFFFFFFFFFFFFL;
    }

    public static int floorMultiple(int i, int factor) {
        return i - i % factor;
    }

    public static int ceilMultiple(int i, int factor) {
        return i + i % factor;
    }

    public static boolean isEven(int i) {
        return (i & 1) == 0;
    }

    public static boolean isOdd(int i) {
        return i % 2 == 1;
    }

    private static int addForNonEven(int i, int c) {
        return MathUtils.isEven(i) ? i : i + c;
    }

    private static int addForNonOdd(int i, int c) {
        return MathUtils.isOdd(i) ? i : i + c;
    }

    public static int floorToEven(int i) {
        return MathUtils.addForNonEven(i, -1);
    }

    public static int floorToOdd(int i) {
        return MathUtils.addForNonOdd(i, -1);
    }

    public static int ceilToEven(int i) {
        return MathUtils.addForNonEven(i, 1);
    }

    public static int ceilToOdd(int i) {
        return MathUtils.addForNonOdd(i, 1);
    }

    private static int sineForRotation(Rotation rot) {
        switch (rot) {
            case NONE: 
            case CLOCKWISE_180: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case COUNTERCLOCKWISE_90: {
                return -1;
            }
        }
        throw new AssertionError();
    }

    private static int cosineForRotation(Rotation rot) {
        return MathUtils.sineForRotation(rot.func_185830_a(Rotation.CLOCKWISE_90));
    }

    public static int[][] rotationMatrixFor(Direction.Axis axis, Rotation rotation) {
        int[][] matrix = new int[3][3];
        switch (axis) {
            case X: {
                matrix[0][0] = 1;
                matrix[1][1] = MathUtils.cosineForRotation(rotation);
                matrix[1][2] = -MathUtils.sineForRotation(rotation);
                matrix[2][1] = MathUtils.sineForRotation(rotation);
                matrix[2][2] = MathUtils.cosineForRotation(rotation);
                break;
            }
            case Y: {
                matrix[1][1] = 1;
                matrix[0][0] = MathUtils.cosineForRotation(rotation);
                matrix[2][0] = -MathUtils.sineForRotation(rotation);
                matrix[0][2] = MathUtils.sineForRotation(rotation);
                matrix[2][2] = MathUtils.cosineForRotation(rotation);
                break;
            }
            case Z: {
                matrix[2][2] = 1;
                matrix[0][0] = MathUtils.cosineForRotation(rotation);
                matrix[0][1] = -MathUtils.sineForRotation(rotation);
                matrix[1][0] = MathUtils.sineForRotation(rotation);
                matrix[1][1] = MathUtils.cosineForRotation(rotation);
            }
        }
        return matrix;
    }

    public static BlockPos matrixMul(int[][] matrix, BlockPos pos) {
        int x = pos.func_177958_n() * matrix[0][0] + pos.func_177956_o() * matrix[0][1] + pos.func_177952_p() * matrix[0][2];
        int y = pos.func_177958_n() * matrix[1][0] + pos.func_177956_o() * matrix[1][1] + pos.func_177952_p() * matrix[1][2];
        int z = pos.func_177958_n() * matrix[2][0] + pos.func_177956_o() * matrix[2][1] + pos.func_177952_p() * matrix[2][2];
        return new BlockPos(x, y, z);
    }
}

