/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry;

import com.direwolf20.buildinggadgets.common.registry.ImmutableOrderedRegistry;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;

public final class TopologicalRegistryBuilder<T> {
    private final MutableGraph<ValueObject<T>> theGraph = GraphBuilder.directed().allowsSelfLoops(false).build();
    private final Map<ResourceLocation, ValueObject<T>> values = new TreeMap<ResourceLocation, ValueObject<T>>();
    private boolean build = false;

    public static <T> TopologicalRegistryBuilder<T> create() {
        return new TopologicalRegistryBuilder<T>();
    }

    private TopologicalRegistryBuilder() {
    }

    public TopologicalRegistryBuilder<T> addAllValues(Map<ResourceLocation, T> values) {
        for (Map.Entry<ResourceLocation, T> entry : values.entrySet()) {
            this.addValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public TopologicalRegistryBuilder<T> addValue(ResourceLocation key, T value) {
        this.validateUnbuild();
        Preconditions.checkArgument((!this.containsValue(value) ? 1 : 0) != 0, (Object)"Cannot have duplicate values, as the mapping needs to be bijective!");
        if (this.values.containsKey(Objects.requireNonNull(key))) {
            ValueObject<T> obj = this.values.get(key);
            obj.setValue(value);
        } else {
            ValueObject obj = new ValueObject(key, value);
            this.values.put(key, obj);
            this.theGraph.addNode(obj);
        }
        return this;
    }

    public TopologicalRegistryBuilder<T> addAllMarkers(Iterable<ResourceLocation> markers) {
        for (ResourceLocation marker : markers) {
            this.addMarker(marker);
        }
        return this;
    }

    public TopologicalRegistryBuilder<T> addMarker(ResourceLocation marker) {
        this.validateUnbuild();
        if (this.values.containsKey(Objects.requireNonNull(marker))) {
            return this;
        }
        ValueObject obj = new ValueObject(marker, null);
        this.values.put(marker, obj);
        this.theGraph.addNode(obj);
        return this;
    }

    public TopologicalRegistryBuilder<T> addDependency(ResourceLocation source, ResourceLocation dependent) {
        this.validateUnbuild();
        if (!this.values.containsKey(source)) {
            this.addMarker(source);
        }
        if (!this.values.containsKey(dependent)) {
            this.addMarker(dependent);
        }
        ValueObject<T> sourceObj = this.values.get(Objects.requireNonNull(source));
        ValueObject<T> dependentObj = this.values.get(Objects.requireNonNull(dependent));
        this.theGraph.putEdge(sourceObj, dependentObj);
        return this;
    }

    public TopologicalRegistryBuilder<T> merge(TopologicalRegistryBuilder<T> other) {
        this.validateUnbuild();
        for (ValueObject node : other.theGraph.nodes()) {
            if (node.getValue() != null) {
                this.addValue(node.getKey(), node.getValue());
                continue;
            }
            this.addMarker(node.getKey());
        }
        for (EndpointPair edge : other.theGraph.edges()) {
            this.addDependency(((ValueObject)edge.source()).getKey(), ((ValueObject)edge.target()).getKey());
        }
        return this;
    }

    public ImmutableOrderedRegistry<T> build() {
        this.validateUnbuild();
        this.build = true;
        this.values.clear();
        List sorted = TopologicalSort.topologicalSort(this.theGraph, Comparator.naturalOrder());
        ImmutableList.Builder objs = ImmutableList.builder();
        ImmutableBiMap.Builder map = ImmutableBiMap.builder();
        sorted.stream().filter(val -> ((ValueObject)val).getValue() != null).forEach(obj -> {
            objs.add(((ValueObject)obj).getValue());
            map.put((Object)((ValueObject)obj).getKey(), ((ValueObject)obj).getValue());
        });
        return new ImmutableOrderedRegistry(map.build(), objs.build());
    }

    private void validateUnbuild() {
        Preconditions.checkState((!this.build ? 1 : 0) != 0, (Object)"Cannot access already created Builder!");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values.values()).add("graph", (Object)("MutableGraph{" + this.theGraph + "}")).toString();
    }

    private boolean containsValue(T value) {
        for (ValueObject<T> existing : this.values.values()) {
            if (((ValueObject)existing).getValue() != value && (((ValueObject)existing).getValue() == null || !((ValueObject)existing).getValue().equals(value))) continue;
            return true;
        }
        return false;
    }

    private static final class ValueObject<T>
    implements Comparable<ValueObject<?>> {
        @Nonnull
        private final ResourceLocation key;
        @Nullable
        private T value;

        private ValueObject(@Nonnull ResourceLocation key, @Nullable T value) {
            this.key = key;
            this.value = value;
        }

        @Nonnull
        private ResourceLocation getKey() {
            return this.key;
        }

        @Nullable
        private T getValue() {
            return this.value;
        }

        public void setValue(@Nonnull T value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public int compareTo(ValueObject<?> o) {
            return this.getKey().compareTo(super.getKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValueObject)) {
                return false;
            }
            ValueObject that = (ValueObject)o;
            return this.getKey().equals((Object)that.getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("key", (Object)this.key).add("value", this.value).toString();
        }
    }
}

