/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketToggleMode {
    private final int mode;

    public static void encode(PacketToggleMode msg, PacketBuffer buffer) {
        buffer.writeInt(msg.mode);
    }

    public static PacketToggleMode decode(PacketBuffer buffer) {
        return new PacketToggleMode(buffer.readInt());
    }

    public PacketToggleMode(int mode) {
        this.mode = mode;
    }

    public static class Handler {
        public static void handle(PacketToggleMode msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity playerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
                if (playerEntity == null) {
                    return;
                }
                ItemStack heldItem = AbstractGadget.getGadget((PlayerEntity)playerEntity);
                if (heldItem.func_190926_b()) {
                    return;
                }
                if (heldItem.func_77973_b() instanceof GadgetBuilding) {
                    GadgetBuilding gadgetBuilding = (GadgetBuilding)heldItem.func_77973_b();
                    gadgetBuilding.setMode(heldItem, msg.mode);
                } else if (heldItem.func_77973_b() instanceof GadgetExchanger) {
                    GadgetExchanger gadgetExchanger = (GadgetExchanger)heldItem.func_77973_b();
                    gadgetExchanger.setMode(heldItem, msg.mode);
                } else if (heldItem.func_77973_b() instanceof GadgetCopyPaste) {
                    GadgetCopyPaste gadgetCopyPaste = (GadgetCopyPaste)heldItem.func_77973_b();
                    gadgetCopyPaste.setMode(heldItem, msg.mode);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

