/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketChangeRange {
    private int range;

    public PacketChangeRange() {
        this.range = -1;
    }

    public PacketChangeRange(int range) {
        this.range = range;
    }

    public static void encode(PacketChangeRange msg, PacketBuffer buffer) {
        buffer.writeInt(msg.range);
    }

    public static PacketChangeRange decode(PacketBuffer buffer) {
        return new PacketChangeRange(buffer.readInt());
    }

    public static class Handler {
        public static void handle(PacketChangeRange msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                ItemStack stack = AbstractGadget.getGadget((PlayerEntity)player);
                if (msg.range >= 0) {
                    GadgetUtils.setToolRange(stack, msg.range);
                } else if (stack.func_77973_b() instanceof GadgetBuilding) {
                    GadgetBuilding.rangeChange((PlayerEntity)player, stack);
                } else if (stack.func_77973_b() instanceof GadgetExchanger) {
                    GadgetExchanger.rangeChange((PlayerEntity)player, stack);
                } else if (stack.func_77973_b() instanceof GadgetDestruction) {
                    GadgetDestruction.switchOverlay((PlayerEntity)player, stack);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

