/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Config {
    private static final String CATEGORY_GENERAL = "general";
    private static final String LANG_KEY_ROOT = "config.buildinggadgets";
    private static final String LANG_KEY_GENERAL = "config.buildinggadgets.general";
    private static final String LANG_KEY_CHARGING_STATION = "config.buildinggadgets.charging";
    private static final String LANG_KEY_BLACKLIST = "config.buildinggadgets.blacklist";
    private static final String LANG_KEY_GADGETS = "config.buildinggadgets.gadgets";
    private static final String LANG_KEY_PASTE_CONTAINERS = "config.buildinggadgets.pasteContainers";
    private static final String LANG_KEY_PASTE_CONTAINERS_CAPACITY = "config.buildinggadgets.pasteContainers.capacity";
    private static final String LANG_KEY_GADGET_BUILDING = "config.buildinggadgets.gadgets.gadgetBuilding";
    private static final String LANG_KEY_GADGET_EXCHANGER = "config.buildinggadgets.gadgets.gadgetExchanger";
    private static final String LANG_KEY_GADGET_DESTRUCTION = "config.buildinggadgets.gadgets.gadgetDestruction";
    private static final String LANG_KEY_GADGET_COPY_PASTE = "config.buildinggadgets.gadgets.gadgetCopyPaste";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final CategoryGeneral GENERAL = new CategoryGeneral();
    public static final CategoryGadgets GADGETS = new CategoryGadgets();
    public static final CategoryPasteContainers PASTE_CONTAINERS = new CategoryPasteContainers();
    public static final ForgeConfigSpec COMMON_CONFIG = COMMON_BUILDER.build();
    public static final ForgeConfigSpec SERVER_CONFIG = SERVER_BUILDER.build();
    public static final ForgeConfigSpec CLIENT_CONFIG = CLIENT_BUILDER.build();

    public static final class CategoryPasteContainers {
        public final ForgeConfigSpec.IntValue capacityT1;
        public final ForgeConfigSpec.IntValue capacityT2;
        public final ForgeConfigSpec.IntValue capacityT3;

        private CategoryPasteContainers() {
            SERVER_BUILDER.comment("Configure the Paste Containers").push("Paste Containers");
            this.capacityT1 = CategoryPasteContainers.getMaxCapacity(1);
            this.capacityT2 = CategoryPasteContainers.getMaxCapacity(2);
            this.capacityT3 = CategoryPasteContainers.getMaxCapacity(3);
            SERVER_BUILDER.pop();
        }

        private static ForgeConfigSpec.IntValue getMaxCapacity(int tier) {
            return SERVER_BUILDER.comment(String.format("The maximum capacity of a tier %s (iron) Construction Paste Container", tier)).translation("config.buildinggadgets.pasteContainers.capacity.t" + tier).defineInRange(String.format("T%s Container Capacity", tier), (int)(512.0 * Math.pow(4.0, tier - 1)), 1, Integer.MAX_VALUE);
        }
    }

    public static final class CategoryGadgets {
        public final ForgeConfigSpec.IntValue maxRange;
        public final ForgeConfigSpec.IntValue placeSteps;
        public final CategoryGadgetBuilding GADGET_BUILDING;
        public final CategoryGadgetExchanger GADGET_EXCHANGER;
        public final CategoryGadgetDestruction GADGET_DESTRUCTION;
        public final CategoryGadgetCopyPaste GADGET_COPY_PASTE;

        private CategoryGadgets() {
            SERVER_BUILDER.comment("Configure the Gadgets").push("Gadgets");
            COMMON_BUILDER.comment("Configure the Gadgets").push("Gadgets");
            this.maxRange = SERVER_BUILDER.comment("The max range of the Gadgets").translation("config.buildinggadgets.gadgets.maxRange").defineInRange("Maximum allowed Range", 15, 1, 32);
            this.placeSteps = SERVER_BUILDER.comment(new String[]{"Maximum amount of Blocks to be placed in one Tick.", "Notice that an EffectBlock takes 20 ticks to place, therefore a Server has to handle 20-times this value effect-block Tile's at once. Reduce this if  you notice lag-spikes from Players placing Templates.", "Of course decreasing this value will result in more time required to place large TemplateItem's."}).translation("config.buildinggadgets.gadgets.gadgetCopyPaste.place_steps").defineInRange("Max Placement/Tick", 1024, 1, Integer.MAX_VALUE);
            this.GADGET_BUILDING = new CategoryGadgetBuilding();
            this.GADGET_EXCHANGER = new CategoryGadgetExchanger();
            this.GADGET_DESTRUCTION = new CategoryGadgetDestruction();
            this.GADGET_COPY_PASTE = new CategoryGadgetCopyPaste();
            COMMON_BUILDER.pop();
            SERVER_BUILDER.pop();
        }

        private static ForgeConfigSpec.IntValue getMaxEnergy(int defaultValue) {
            return SERVER_BUILDER.comment("The max energy of the Gadget, set to 0 to disable energy usage").translation("config.buildinggadgets.gadgets.maxEnergy").defineInRange("Maximum Energy", defaultValue, 0, Integer.MAX_VALUE);
        }

        private static ForgeConfigSpec.IntValue getEnergyCost(int defaultValue) {
            return SERVER_BUILDER.comment("The Gadget's Energy cost per Operation").translation("config.buildinggadgets.gadgets.energyCost").defineInRange("Energy Cost", defaultValue, 0, Integer.MAX_VALUE);
        }

        private static ForgeConfigSpec.IntValue getMaxUndoSize(int defaultValue) {
            return SERVER_BUILDER.comment("The Gadget'S Max Undo size").translation("config.buildinggadgets.gadgets.undo_size").defineInRange("Max Undo History Size", defaultValue, 0, 128);
        }

        public static final class CategoryGadgetCopyPaste {
            public final ForgeConfigSpec.IntValue maxEnergy;
            public final ForgeConfigSpec.IntValue energyCost;
            public final ForgeConfigSpec.IntValue undoSize;
            public final ForgeConfigSpec.IntValue copySteps;
            public final ForgeConfigSpec.IntValue maxCopySize;
            public final ForgeConfigSpec.IntValue maxBuildSize;

            private CategoryGadgetCopyPaste() {
                SERVER_BUILDER.comment("Energy Cost & Durability of the Copy-Paste Gadget").push("Copy-Paste Gadget");
                this.maxEnergy = CategoryGadgets.getMaxEnergy(500000);
                this.energyCost = CategoryGadgets.getEnergyCost(50);
                this.undoSize = CategoryGadgets.getMaxUndoSize(1);
                this.copySteps = SERVER_BUILDER.comment(new String[]{"Maximum amount of Blocks to be copied in one Tick. ", "Lower values may improve Server-Performance when copying large Templates"}).translation("config.buildinggadgets.gadgets.gadgetCopyPaste.copy_steps").defineInRange("Max Copy/Tick", 32768, 1, Integer.MAX_VALUE);
                this.maxCopySize = SERVER_BUILDER.comment(new String[]{"Maximum dimensions (x, y and z) that can be copied by a Template without requiring special permission.", "Permission can be granted using the '/buildinggadgets OverrideCopySize [<Player>]' command."}).translation("config.buildinggadgets.gadgets.gadgetCopyPaste.max_copy").defineInRange("Max Copy Dimensions", 256, -1, Integer.MAX_VALUE);
                this.maxBuildSize = SERVER_BUILDER.comment(new String[]{"Maximum dimensions (x, y and z) that can be build by a Template without requiring special permission.", "Permission can be granted using the '/buildinggadgets OverrideBuildSize [<Player>]' command."}).translation("config.buildinggadgets.gadgets.gadgetCopyPaste.max_build").defineInRange("Max Build Dimensions", 256, -1, Integer.MAX_VALUE);
                SERVER_BUILDER.pop();
            }
        }

        public static final class CategoryGadgetDestruction {
            public final ForgeConfigSpec.IntValue maxEnergy;
            public final ForgeConfigSpec.IntValue energyCost;
            public final ForgeConfigSpec.IntValue undoSize;
            public final ForgeConfigSpec.IntValue destroySize;
            public final ForgeConfigSpec.DoubleValue nonFuzzyMultiplier;
            public final ForgeConfigSpec.BooleanValue nonFuzzyEnabled;

            private CategoryGadgetDestruction() {
                SERVER_BUILDER.comment("Energy Cost, Durability & Maximum Energy of the Destruction Gadget").push("Destruction Gadget");
                this.maxEnergy = CategoryGadgets.getMaxEnergy(1000000);
                this.energyCost = CategoryGadgets.getEnergyCost(200);
                this.undoSize = CategoryGadgets.getMaxUndoSize(1);
                this.destroySize = SERVER_BUILDER.comment("The maximum dimensions, the Destruction Gadget can destroy.").translation("config.buildinggadgets.gadgets.gadgetDestruction.destroy_size").defineInRange("Destroy Dimensions", 16, 0, 32);
                this.nonFuzzyMultiplier = SERVER_BUILDER.comment("The cost in energy/durability will increase by this amount when not in fuzzy mode").translation("config.buildinggadgets.gadgets.gadgetDestruction.nonfuzzy.multiplier").defineInRange("Non-Fuzzy Mode Multiplier", 2.0, 0.0, Double.MAX_VALUE);
                this.nonFuzzyEnabled = SERVER_BUILDER.comment("If enabled, the Destruction Gadget can be taken out of fuzzy mode, allowing only instances of the block clicked to be removed (at a higher cost)").translation("config.buildinggadgets.gadgets.gadgetDestruction.nonfuzzy.enabled").define("Non-Fuzzy Mode Enabled", false);
                SERVER_BUILDER.pop();
            }
        }

        public static final class CategoryGadgetExchanger {
            public final ForgeConfigSpec.IntValue maxEnergy;
            public final ForgeConfigSpec.IntValue energyCost;
            public final ForgeConfigSpec.IntValue undoSize;

            private CategoryGadgetExchanger() {
                SERVER_BUILDER.comment("Energy Cost & Durability of the Exchanging Gadget").push("Exchanging Gadget");
                this.maxEnergy = CategoryGadgets.getMaxEnergy(500000);
                this.energyCost = CategoryGadgets.getEnergyCost(100);
                this.undoSize = CategoryGadgets.getMaxUndoSize(10);
                SERVER_BUILDER.pop();
            }
        }

        public static final class CategoryGadgetBuilding {
            public final ForgeConfigSpec.IntValue maxEnergy;
            public final ForgeConfigSpec.IntValue energyCost;
            public final ForgeConfigSpec.IntValue undoSize;

            private CategoryGadgetBuilding() {
                SERVER_BUILDER.comment("Energy Cost & Durability of the Building Gadget").push("Building Gadget");
                this.maxEnergy = CategoryGadgets.getMaxEnergy(500000);
                this.energyCost = CategoryGadgets.getEnergyCost(50);
                this.undoSize = CategoryGadgets.getMaxUndoSize(10);
                SERVER_BUILDER.pop();
            }
        }
    }

    public static final class CategoryGeneral {
        public final ForgeConfigSpec.DoubleValue rayTraceRange;
        public final ForgeConfigSpec.BooleanValue allowAbsoluteCoords;
        public final ForgeConfigSpec.BooleanValue absoluteCoordDefault;
        public final ForgeConfigSpec.BooleanValue allowOverwriteBlocks;

        private CategoryGeneral() {
            SERVER_BUILDER.comment("General mod settings").push(Config.CATEGORY_GENERAL);
            CLIENT_BUILDER.comment("General mod settings").push(Config.CATEGORY_GENERAL);
            this.allowAbsoluteCoords = SERVER_BUILDER.comment("Defined whether or not a player can use Absolute Coords mode in the Copy Paste Gadget").define("Allow Absolute Coords", true);
            this.rayTraceRange = SERVER_BUILDER.comment("Defines how far away you can build").translation("config.buildinggadgets.general.rayTraceRange").defineInRange("MaxBuildDistance", 32.0, 1.0, 48.0);
            this.absoluteCoordDefault = CLIENT_BUILDER.comment(new String[]{"Determines if the Copy/Paste GUI's coordinate mode starts in 'Absolute' mode by default.", "Set to true for Absolute, set to False for Relative."}).translation("config.buildinggadgets.general.absoluteCoordDefault").define("Default to absolute Coord-Mode", false);
            this.allowOverwriteBlocks = SERVER_BUILDER.comment(new String[]{"Whether the Building / CopyPaste Gadget can overwrite blocks like water, lava, grass, etc (like a player can).", "False will only allow it to overwrite air blocks."}).translation("config.buildinggadgets.general.allowOverwriteBlocks").define("Allow non-Air-Block-Overwrite", true);
            CLIENT_BUILDER.pop();
            SERVER_BUILDER.pop();
        }
    }
}

