/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.concurrent;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.common.concurrent.ServerTickingScheduler;
import com.direwolf20.buildinggadgets.common.concurrent.SteppedScheduler;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.save.Undo;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public final class UndoScheduler
extends SteppedScheduler {
    private final Spliterator<Map.Entry<BlockPos, Undo.BlockInfo>> spliterator;
    private boolean lastWasSuccess;
    private final IBuildContext context;
    private final IItemIndex index;

    public static UndoScheduler scheduleUndo(Undo undo, IItemIndex index, IBuildContext context, int steps) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
        UndoScheduler res = new UndoScheduler(Objects.requireNonNull(undo), Objects.requireNonNull(index), Objects.requireNonNull(context), steps);
        ServerTickingScheduler.runTicked(res);
        return res;
    }

    private UndoScheduler(Undo undo, IItemIndex index, IBuildContext context, int steps) {
        super(steps);
        assert (context.getBuildingPlayer() != null);
        assert (!context.getUsedStack().func_190926_b());
        this.spliterator = undo.getUndoData().entrySet().spliterator();
        this.index = index;
        this.context = context;
    }

    @Override
    protected SteppedScheduler.StepResult advance() {
        if (!this.spliterator.tryAdvance(this::undoBlock)) {
            return SteppedScheduler.StepResult.END;
        }
        return this.lastWasSuccess ? SteppedScheduler.StepResult.SUCCESS : SteppedScheduler.StepResult.FAILURE;
    }

    private void undoBlock(Map.Entry<BlockPos, Undo.BlockInfo> entry) {
        BlockEvent.BreakEvent event;
        BlockState state = this.context.getWorld().func_180495_p(entry.getKey());
        TileEntity te = this.context.getWorld().func_175625_s(entry.getKey());
        BlockData data = state.func_177230_c() == OurBlocks.constructionBlock && te instanceof ConstructionBlockTileEntity ? ((ConstructionBlockTileEntity)te).getConstructionBlockData() : TileSupport.createBlockData(state, te);
        if (!data.equals(entry.getValue().getPlacedData())) {
            this.lastWasSuccess = false;
            return;
        }
        if (!state.isAir((IBlockReader)this.context.getWorld(), entry.getKey()) && MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(this.context.getWorld().func_201672_e(), entry.getKey(), state, this.context.getBuildingPlayer())))) {
            this.lastWasSuccess = false;
            return;
        }
        MatchResult matchResult = this.index.tryMatch(entry.getValue().getProducedItems());
        this.lastWasSuccess = matchResult.isSuccess();
        if (this.lastWasSuccess) {
            this.index.applyMatch(matchResult);
            this.index.insert(entry.getValue().getUsedItems());
            EffectBlock.spawnUndoBlock(this.context, new PlacementTarget(entry.getKey(), entry.getValue().getRecordedData()));
        }
    }

    @Override
    protected void onFinish() {
    }
}

