/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.concurrent;

import java.util.function.BooleanSupplier;

public abstract class SteppedScheduler
implements BooleanSupplier {
    private final int steps;
    private boolean finished;

    public SteppedScheduler(int steps) {
        this.steps = steps;
        this.finished = false;
    }

    @Override
    public boolean getAsBoolean() {
        boolean res;
        if (this.finished) {
            return false;
        }
        for (int i = 0; this.advance() != StepResult.END && i < this.steps - 1; ++i) {
        }
        boolean bl = res = this.advance() != StepResult.END;
        if (!res) {
            this.finished = true;
            this.onFinish();
        }
        return res;
    }

    protected abstract StepResult advance();

    protected abstract void onFinish();

    protected static enum StepResult {
        SUCCESS,
        FAILURE,
        END;


        public static StepResult ofBoolean(boolean b) {
            return b ? SUCCESS : END;
        }
    }
}

