/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.render;

import com.davenonymous.libnonymous.render.MultiBlockModelWorldReader;
import com.davenonymous.libnonymous.render.MultiblockBlockModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class MultiblockBlockModelRenderer {
    private static final Random rand = new Random();

    public static void renderModel(MultiblockBlockModel model, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        MultiBlockModelWorldReader modelWorld = new MultiBlockModelWorldReader(model);
        MultiblockBlockModelRenderer.renderModel(model, modelWorld, matrix, buffer, light, overlay);
    }

    public static void renderModel(MultiblockBlockModel model, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay, IWorldReader worldContext, BlockPos blockContext) {
        MultiBlockModelWorldReader modelWorld = new MultiBlockModelWorldReader(model, worldContext, blockContext);
        MultiblockBlockModelRenderer.renderModel(model, modelWorld, matrix, buffer, light, overlay);
    }

    private static void renderModel(MultiblockBlockModel model, MultiBlockModelWorldReader modelWorld, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        Set<BlockPos> renderPositions = model.getRelevantPositions();
        for (BlockPos pos : renderPositions) {
            BlockState state = model.blocks.get(pos);
            try {
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                if (modelWorld.getContextWorld() != null && modelWorld.getContextPos() != null) {
                    AmbientOcclusionStatus before = Minecraft.func_71410_x().field_71474_y.field_74348_k;
                    Minecraft.func_71410_x().field_71474_y.field_74348_k = AmbientOcclusionStatus.OFF;
                    brd.renderModel(state, modelWorld.getContextPos(), (ILightReader)modelWorld.getContextWorld(), matrix, buffer.getBuffer(RenderType.func_228643_e_()), false, rand, (IModelData)EmptyModelData.INSTANCE);
                    Minecraft.func_71410_x().field_71474_y.field_74348_k = before;
                } else {
                    brd.renderBlock(state, matrix, buffer, light, overlay, (IModelData)EmptyModelData.INSTANCE);
                }
                matrix.func_227865_b_();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

