/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseEnterEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseExitEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetButton;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetWithChoiceValue;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class WidgetSelectButton<T>
extends WidgetWithChoiceValue<T> {
    public boolean hovered = false;
    public ResourceLocation backgroundTexture;
    public TextureAtlasSprite atlasSprite;
    public SoundEvent clickSound;

    public WidgetSelectButton() {
        this.setHeight(20);
        this.setWidth(100);
        this.clickSound = SoundEvents.field_187909_gi;
        this.backgroundTexture = GUI.defaultButtonTexture;
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            ((WidgetSelectButton)widget).hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            ((WidgetSelectButton)widget).hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)this.clickSound, (float)1.0f));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addClickListener();
    }

    public WidgetSelectButton<T> setClickSound(SoundEvent clickSound) {
        this.clickSound = clickSound;
        return this;
    }

    public WidgetSelectButton<T> setBackgroundTexture(ResourceLocation backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public WidgetSelectButton<T> setAtlasSprite(TextureAtlasSprite atlasSprite) {
        this.atlasSprite = atlasSprite;
        return this;
    }

    @Override
    public void draw(Screen screen) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)2.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.atlasSprite != null) {
            screen.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            WidgetButton.fillAreaWithIcon(this.atlasSprite, 0, 0, this.width, this.height);
        } else {
            screen.getMinecraft().func_110434_K().func_110577_a(this.backgroundTexture);
            GUIHelper.drawModalRectWithCustomSizedTexture(0, 0, 0.0f, 0.0f, this.width, this.height, 16.0f, 16.0f);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.hovered ? 1.0f : 1.0f));
        screen.getMinecraft().func_110434_K().func_110577_a(GUI.tabIcons);
        int texOffsetX = 64;
        int texOffsetY = 84;
        int overlayWidth = 20;
        GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)texOffsetX, (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(0 + this.width - 4), (int)0, (int)(texOffsetX + overlayWidth - 4), (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)0, (int)(this.height - 4), (int)texOffsetX, (int)(texOffsetY + overlayWidth - 4), (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(0 + this.width - 4), (int)(this.height - 4), (int)(texOffsetX + overlayWidth - 4), (int)(texOffsetY + overlayWidth - 4), (int)4, (int)4, (float)0.0f);
        GUIHelper.drawStretchedTexture(4, 0, this.width - 8, 4, texOffsetX + 4, texOffsetY, 12, 4);
        GUIHelper.drawStretchedTexture(4, this.height - 4, this.width - 8, 4, texOffsetX + 4, texOffsetY + overlayWidth - 4, 12, 4);
        GUIHelper.drawStretchedTexture(0, 4, 4, this.height - 8, texOffsetX, texOffsetY + 4, 4, 12);
        GUIHelper.drawStretchedTexture(0 + this.width - 4, 4, 4, this.height - 8, texOffsetX + overlayWidth - 4, texOffsetY + 3, 4, 12);
        FontRenderer fontrenderer = screen.getMinecraft().field_71466_p;
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)10.0f);
        this.drawButtonContent(screen, fontrenderer);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-10.0f);
        if (!this.enabled) {
            GUIHelper.drawColoredRectangle(1, 1, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        } else if (this.hovered) {
            GUIHelper.drawColoredRectangle(1, 1, this.width - 2, this.height - 2, -2139057921);
        }
        RenderSystem.popMatrix();
    }

    protected void drawButtonContent(Screen screen, FontRenderer fontrenderer) {
        int color = 0xEEEEEE;
        screen.drawCenteredString(fontrenderer, this.getValue().toString(), this.width / 2, (this.height - 8) / 2, color);
    }
}

