/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.capabilities.DefaultSuperAdmin;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.core.FireItemEntity;
import sonar.fluxnetworks.common.data.FluxChunkManager;
import sonar.fluxnetworks.common.event.FluxConnectionEvent;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.NetworkUpdatePacket;
import sonar.fluxnetworks.common.network.SuperAdminPacket;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.registry.RegistryItems;

public class EventHandler {
    @SubscribeEvent
    public static void onServerStarted(FMLServerStartedEvent event) {
        FluxNetworks.proxy.onServerStarted();
    }

    @SubscribeEvent
    public static void onServerStopped(FMLServerStoppedEvent event) {
        FluxNetworkCache.instance.clearNetworks();
        FluxNetworkCache.instance.clearClientCache();
        FluxNetworks.proxy.onServerStopped();
        FluxChunkManager.clear();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (IFluxNetwork network : FluxNetworkCache.instance.getAllNetworks()) {
                network.onEndServerTick();
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            FluxChunkManager.loadWorld((ServerWorld)event.getWorld());
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getSide().isServer()) {
            if (!FluxConfig.enableFluxRecipe) {
                return;
            }
            ServerWorld world = (ServerWorld)event.getWorld();
            BlockPos pos = event.getPos();
            BlockState crusher = world.func_180495_p(pos);
            BlockState base = world.func_180495_p(pos.func_177979_c(2));
            if (crusher.func_177230_c().equals(Blocks.field_150343_Z) && base.func_177230_c().equals(Blocks.field_150357_h) || base.func_177230_c().equals(RegistryBlocks.FLUX_BLOCK)) {
                List entities = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(pos.func_177977_b()));
                if (entities.isEmpty()) {
                    return;
                }
                ArrayList s = Lists.newArrayList();
                AtomicInteger count = new AtomicInteger();
                entities.forEach(e -> {
                    if (e.func_92059_d().func_77973_b().equals(Items.field_151137_ax)) {
                        s.add(e);
                        count.addAndGet(e.func_92059_d().func_190916_E());
                    }
                });
                if (s.isEmpty()) {
                    return;
                }
                ItemStack stack = new ItemStack((IItemProvider)RegistryItems.FLUX, count.getAndIncrement());
                s.forEach(Entity::func_70106_y);
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                world.func_217376_c((Entity)new ItemEntity((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, stack));
                world.func_175656_a(pos.func_177977_b(), Blocks.field_150343_Z.func_176223_P());
                world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityAdded(EntityJoinWorldEvent event) {
        ItemEntity entityItem;
        ItemStack stack;
        if (!FluxConfig.enableFluxRecipe || !FluxConfig.enableOldRecipe || event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && !(entity instanceof FireItemEntity) && !(stack = (entityItem = (ItemEntity)entity).func_92059_d()).func_190926_b() && stack.func_77973_b() == Items.field_151137_ax) {
            FireItemEntity newEntity = new FireItemEntity(entityItem);
            entityItem.func_70106_y();
            event.getWorld().func_217376_c((Entity)newEntity);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new NetworkUpdatePacket(new ArrayList<IFluxNetwork>(FluxNetworkCache.instance.getAllNetworks()), NBTType.NETWORK_GENERAL));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SuperAdminPacket(DefaultSuperAdmin.isPlayerSuperAdmin(player)));
        }
    }

    @SubscribeEvent
    public static void onFluxConnected(FluxConnectionEvent.Connected event) {
        if (!event.flux.getDimension().field_72995_K) {
            event.flux.connect(event.network);
        }
    }

    @SubscribeEvent
    public static void onFluxDisconnect(FluxConnectionEvent.Disconnected event) {
        if (!event.flux.getDimension().field_72995_K) {
            event.flux.disconnect(event.network);
        }
    }
}

