/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.AbstractPacket;
import sonar.fluxnetworks.common.network.TilePacketEnum;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class TilePacket
extends AbstractPacket {
    public TilePacketEnum handler;
    public CompoundNBT tag;
    public BlockPos pos;
    public int dimension;

    public TilePacket(PacketBuffer buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.dimension = buf.readInt();
        this.handler = TilePacketEnum.values()[buf.readInt()];
        this.tag = buf.func_150793_b();
    }

    public TilePacket(TilePacketEnum handler, CompoundNBT tag, BlockPos pos, int dimension) {
        this.handler = handler;
        this.tag = tag;
        this.pos = pos;
        this.dimension = dimension;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.dimension);
        buf.writeInt(this.handler.ordinal());
        buf.func_150786_a(this.tag);
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        PlayerEntity player = PacketHandler.getPlayer(ctx);
        if (player != null) {
            TileEntity tile;
            World world = player.func_130014_f_();
            if (world.func_201675_m().func_186058_p().func_186068_a() != this.dimension) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                world = server.func_71218_a(DimensionType.func_186069_a((int)this.dimension));
            }
            if ((tile = world.func_175625_s(this.pos)) instanceof TileFluxCore) {
                TileFluxCore flux = (TileFluxCore)tile;
                return this.handler.handler.handlePacket(flux, player, this.tag);
            }
        }
        return null;
    }
}

