/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.network.AbstractPacket;

public class NetworkUpdatePacket
extends AbstractPacket {
    public Map<Integer, CompoundNBT> updatedNetworks = new HashMap<Integer, CompoundNBT>();
    public NBTType type;

    public NetworkUpdatePacket(PacketBuffer buf) {
        this.type = NBTType.values()[buf.readInt()];
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.updatedNetworks.put(buf.readInt(), buf.func_150793_b());
        }
    }

    public NetworkUpdatePacket(List<IFluxNetwork> toSend, NBTType type) {
        this.type = type;
        toSend.forEach(n -> {
            CompoundNBT tag = new CompoundNBT();
            n.writeNetworkNBT(tag, type);
            if (!tag.isEmpty()) {
                this.updatedNetworks.put(n.getNetworkID(), tag);
            }
        });
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.updatedNetworks.size());
        this.updatedNetworks.forEach((i, n) -> {
            buf.writeInt(i.intValue());
            buf.func_150786_a(n);
        });
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        FluxNetworkCache.instance.updateClientFromPacket(this.updatedNetworks, this.type);
        return null;
    }
}

