/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.handler;

import net.minecraft.nbt.CompoundNBT;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.ITransferHandler;
import sonar.fluxnetworks.api.tiles.IFluxConnector;

public abstract class AbstractTransferHandler<C extends IFluxConnector>
implements ITransferHandler {
    public long buffer;
    public final C fluxConnector;
    protected long addedToBuffer;
    protected long removedFromBuffer;
    protected long change;

    public AbstractTransferHandler(C fluxConnector) {
        this.fluxConnector = fluxConnector;
    }

    public IFluxNetwork getNetwork() {
        return this.fluxConnector.getNetwork();
    }

    @Override
    public void onStartCycle() {
        this.change = 0L;
        this.addedToBuffer = 0L;
        this.removedFromBuffer = 0L;
    }

    @Override
    public void onEndCycle() {
    }

    @Override
    public long addEnergyToBuffer(long energy, boolean simulate) {
        long add = this.getMaxAdd(energy);
        if (add > 0L) {
            if (!simulate) {
                this.buffer += add;
                this.addedToBuffer += add;
            }
            return add;
        }
        return 0L;
    }

    @Override
    public long removeEnergyFromBuffer(long energy, boolean simulate) {
        long remove = this.getMaxRemove(energy);
        if (remove > 0L) {
            if (!simulate) {
                this.buffer -= remove;
                this.removedFromBuffer += remove;
            }
            return remove;
        }
        return 0L;
    }

    @Override
    public long getBuffer() {
        return this.buffer;
    }

    @Override
    public long getRequest() {
        return 0L;
    }

    @Override
    public long getChange() {
        return this.change;
    }

    public long getAddLimit() {
        return this.fluxConnector.getCurrentLimit();
    }

    public long getRemoveLimit() {
        return this.fluxConnector.getCurrentLimit();
    }

    public long getMaxAdd(long toAdd) {
        return Math.max(Math.min(this.getAddLimit() - this.addedToBuffer, toAdd), 0L);
    }

    public long getMaxRemove(long toRemove) {
        return Math.max(Math.min(this.getRemoveLimit() - this.removedFromBuffer, Math.min(toRemove, this.getBuffer())), 0L);
    }

    @Override
    public CompoundNBT writeNetworkedNBT(CompoundNBT tag) {
        tag.func_74772_a("71", this.change);
        tag.func_74772_a("72", this.buffer);
        return tag;
    }

    @Override
    public void readNetworkedNBT(CompoundNBT tag) {
        this.change = tag.func_74763_f("71");
        this.buffer = tag.func_74763_f("72");
    }
}

