/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.common.block.FluxNetworkBlock;
import sonar.fluxnetworks.common.tileentity.TileFluxStorage;

public abstract class FluxStorageBlock
extends FluxNetworkBlock {
    public FluxStorageBlock(Block.Properties props) {
        super(props);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return VoxelShapes.func_197868_b();
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(FluxTranslate.FLUX_STORAGE_TOOLTIP.k(), new Object[0]));
    }

    public abstract int getMaxStorage();

    public static class Gargantuan
    extends FluxStorageBlock {
        public Gargantuan(Block.Properties props) {
            super(props);
        }

        @Override
        public int getMaxStorage() {
            return FluxConfig.gargantuanCapacity;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TileFluxStorage.Gargantuan();
        }
    }

    public static class Herculean
    extends FluxStorageBlock {
        public Herculean(Block.Properties props) {
            super(props);
        }

        @Override
        public int getMaxStorage() {
            return FluxConfig.herculeanCapacity;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TileFluxStorage.Herculean();
        }
    }

    public static class Basic
    extends FluxStorageBlock {
        public Basic(Block.Properties props) {
            super(props);
        }

        @Override
        public int getMaxStorage() {
            return FluxConfig.basicCapacity;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TileFluxStorage.Basic();
        }
    }
}

