/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.base.ItemEntityInteractable;
import com.lothrazar.cyclic.block.cable.CableWrench;
import com.lothrazar.cyclic.block.cable.WrenchActionType;
import com.lothrazar.cyclic.block.scaffolding.ItemScaffolding;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilSound;
import com.lothrazar.cyclic.util.UtilWorld;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemEvents {
    @SubscribeEvent
    public void onPlayerCloneDeath(PlayerEvent.Clone event) {
        IAttributeInstance original = event.getOriginal().func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (original != null) {
            UtilEntity.setMaxHealth((LivingEntity)event.getPlayer(), original.func_111126_e());
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public void onBedCheck(SleepingLocationCheckEvent event) {
        PlayerEntity p;
        if (event.getEntity() instanceof PlayerEntity && (p = (PlayerEntity)event.getEntity()).getPersistentData().func_74767_n("cyclic_sleeping")) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof ItemScaffolding && event.getPlayer().func_213453_ef()) {
            this.scaffoldHit(event);
        }
    }

    private void scaffoldHit(PlayerInteractEvent.RightClickBlock event) {
        ItemScaffolding item = (ItemScaffolding)event.getItemStack().func_77973_b();
        Direction opp = event.getFace().func_176734_d();
        BlockPos dest = UtilWorld.nextReplaceableInDirection(event.getWorld(), event.getPos(), opp, 16, item.func_179223_d());
        if (event.getWorld().func_175623_d(dest)) {
            event.getWorld().func_175656_a(dest, item.func_179223_d().func_176223_P());
            ItemStack stac = event.getPlayer().func_184586_b(event.getHand());
            UtilItemStack.shrink(event.getPlayer(), stac);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().func_77973_b() instanceof ItemEntityInteractable) {
            ItemEntityInteractable item = (ItemEntityInteractable)event.getItemStack().func_77973_b();
            item.interactWith(event);
        }
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held.func_190926_b()) {
            return;
        }
        World world = player.func_130014_f_();
        if (held.func_77973_b() instanceof BuilderItem) {
            if (BuilderActionType.getTimeout(held) > 0) {
                return;
            }
            BuilderActionType.setTimeout(held);
            event.setCanceled(true);
            if (player.func_213453_ef()) {
                BlockState target = world.func_180495_p(event.getPos());
                BuilderActionType.setBlockState(held, target);
                UtilChat.sendStatusMessage(player, target.func_177230_c().func_149739_a());
            } else {
                if (!world.field_72995_K) {
                    BuilderActionType.toggle(held);
                }
                UtilSound.playSound(player, SoundRegistry.tool_mode);
                UtilChat.sendStatusMessage(player, UtilChat.lang(BuilderActionType.getName(held)));
            }
        }
        if (held.func_77973_b() instanceof CableWrench && WrenchActionType.getTimeout(held) == 0) {
            if (!world.field_72995_K) {
                WrenchActionType.toggle(held);
            }
            UtilSound.playSound(player, SoundRegistry.tool_mode);
            WrenchActionType.setTimeout(held);
            UtilChat.sendStatusMessage(player, UtilChat.lang(WrenchActionType.getName(held)));
        }
    }
}

