/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tank;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.tank.RenderTank;
import com.lothrazar.cyclic.block.tank.TileTank;
import com.lothrazar.cyclic.capability.FluidHandlerCapabilityStack;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class BlockFluidTank
extends BlockBase {
    public static final BooleanProperty TANK_ABOVE = BooleanProperty.func_177716_a((String)"above");
    public static final BooleanProperty TANK_BELOW = BooleanProperty.func_177716_a((String)"below");
    public static final int heightCheckMax = 16;

    public BlockFluidTank(Block.Properties properties) {
        super(properties.harvestTool(ToolType.PICKAXE).func_200943_b(1.2f).func_226896_b_());
    }

    @Deprecated
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{TANK_ABOVE, TANK_BELOW});
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        boolean tileAbove = world.func_175625_s(pos.func_177984_a()) instanceof TileTank;
        boolean tileBelow = world.func_175625_s(pos.func_177977_b()) instanceof TileTank;
        return (BlockState)((BlockState)state.func_206870_a((IProperty)TANK_ABOVE, (Comparable)Boolean.valueOf(tileAbove))).func_206870_a((IProperty)TANK_BELOW, (Comparable)Boolean.valueOf(tileBelow));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileTank();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        IFluidHandler handler;
        TileEntity tankHere;
        if (!world.field_72995_K && (tankHere = world.func_175625_s(pos)) != null && (handler = (IFluidHandler)tankHere.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b()).orElse(null)) != null && FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)handler)) {
            if (handler.getFluidInTank(0) != null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("" + handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0), new Object[0]), true);
            }
            if (player instanceof ServerPlayerEntity) {
                UtilSound.playSoundFromServer((ServerPlayerEntity)player, SoundEvents.field_187630_M);
            }
        }
        if (FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)).isPresent()) {
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228645_f_());
        ClientRegistry.bindTileEntityRenderer(BlockRegistry.Tiles.tank, RenderTank::new);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        try {
            IFluidHandler storageTile;
            IFluidHandlerItem storage = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
            TileEntity container = world.func_175625_s(pos);
            if (storage != null && container != null && (storageTile = (IFluidHandler)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null)) != null) {
                storageTile.fill(storage.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        catch (Exception e) {
            ModCyclic.error("Error during fill from item ", e);
        }
        state = (BlockState)((BlockState)state.func_206870_a((IProperty)TANK_ABOVE, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)TANK_BELOW, (Comparable)Boolean.valueOf(false));
        world.func_175656_a(pos, state);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity ent, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, ent, stack);
        ItemStack tankStack = new ItemStack((IItemProvider)this);
        if (ent != null) {
            IFluidHandler fluidInTile = (IFluidHandler)ent.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null);
            IFluidHandler fluidInStack = (IFluidHandler)tankStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
            if (fluidInStack != null) {
                FluidStack fs = fluidInTile.getFluidInTank(0);
                ((FluidHandlerCapabilityStack)fluidInStack).setFluid(fs);
            }
        }
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), tankStack));
        }
    }
}

