/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.data;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class TelePattern {
    public static final int LENGTH = GameWorld.Directions.CLOCKWISE_HORIZONTALS.length;
    public static final TelePattern NONE = new TelePattern(new BlockState[0]);
    protected final BlockState[] blocks;

    @Nonnull
    public static Data getData(ServerWorld world) {
        Data data = (Data)world.func_217481_x().func_215752_a(Data::new, Data.ID);
        return data;
    }

    public static void updateAt(ServerWorld world, BlockPos pos) {
        Data data = TelePattern.getData(world);
        TelePattern pattern = TelePattern.from((World)world, pos);
        if (pattern.isValid()) {
            data.patterns.put(pos, pattern);
        } else {
            data.patterns.remove(pos);
        }
        data.func_76185_a();
    }

    public static TelePattern from(World world, BlockPos pos) {
        BlockState[] blocks = new BlockState[LENGTH];
        for (int i = 0; i < LENGTH; ++i) {
            Direction facing = GameWorld.Directions.CLOCKWISE_HORIZONTALS[i];
            blocks[i] = world.func_180495_p(pos.func_177972_a(facing));
        }
        TelePattern pattern = new TelePattern(blocks);
        return pattern;
    }

    public static TelePattern from(CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c(Tags.BLOCKS.name(), ForgeNBT.Types.COMPOUND.id);
        int length = list.size();
        BlockState[] blocks = new BlockState[length];
        for (int i = 0; i < length; ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            blocks[i] = NBTUtil.func_190008_d((CompoundNBT)tag);
        }
        return new TelePattern(blocks);
    }

    protected TelePattern(BlockState ... blocks) {
        this.blocks = Arrays.copyOf(blocks, LENGTH);
    }

    public TelePattern rotate() {
        BlockState[] rotated = new BlockState[LENGTH];
        System.arraycopy(this.blocks, 0, rotated, 1, LENGTH - 1);
        rotated[0] = this.blocks[LENGTH - 1];
        return new TelePattern(rotated);
    }

    public boolean isValid() {
        for (BlockState state : this.blocks) {
            if (state != null && state.func_185904_a() != Material.field_151579_a) continue;
            return false;
        }
        return true;
    }

    public TelePattern[] getVariants() {
        TelePattern[] variants = new TelePattern[LENGTH];
        variants[0] = this;
        for (int i = 1; i < LENGTH; ++i) {
            variants[i] = variants[i - 1].rotate();
        }
        return variants;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TelePattern) {
            TelePattern pattern = (TelePattern)obj;
            return Arrays.equals(this.blocks, pattern.blocks);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Arrays.hashCode(this.blocks);
    }

    public void writeToNBT(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (BlockState state : this.blocks) {
            CompoundNBT tag = NBTUtil.func_190009_a((BlockState)state);
            list.add((Object)tag);
        }
        nbt.func_218657_a(Tags.BLOCKS.name(), (INBT)list);
    }

    static enum Tags {
        BLOCKS;

    }

    static class Data
    extends WorldSavedData {
        static final String ID = UnitId.buildRegName((String[])new String[]{"adpoles", "tele", "patterns"});
        protected final Map<BlockPos, TelePattern> patterns = new ConcurrentHashMap<BlockPos, TelePattern>();

        public Data() {
            super(ID);
        }

        public void func_76184_a(CompoundNBT nbt) {
            ListNBT list = nbt.func_150295_c(ID, ForgeNBT.Types.COMPOUND.id);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)tag);
                TelePattern pattern = TelePattern.from(tag);
                if (pattern.isValid()) {
                    this.patterns.put(pos, pattern);
                    continue;
                }
                ForgeEndertech.debugMsg((String)("Loaded invalid tele pattern at: " + pos + ", " + pattern));
            }
        }

        public CompoundNBT func_189551_b(CompoundNBT compound) {
            ListNBT list = new ListNBT();
            for (Map.Entry<BlockPos, TelePattern> entry : this.patterns.entrySet()) {
                CompoundNBT tag = NBTUtil.func_186859_a((BlockPos)entry.getKey());
                entry.getValue().writeToNBT(tag);
                list.add((Object)tag);
            }
            compound.func_218657_a(ID, (INBT)list);
            return compound;
        }
    }
}

