/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.TopSolidOnce;

public class WaystonePlacement
extends TopSolidOnce {
    public WaystonePlacement(Function<Dynamic<?>, ? extends NoPlacementConfig> configFactory) {
        super(configFactory);
    }

    public Stream<BlockPos> func_212848_a_(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, NoPlacementConfig config, BlockPos pos) {
        if (this.isWaystoneChunk(world, pos)) {
            return super.func_212848_a_(world, chunkGenerator, random, config, pos);
        }
        return Stream.empty();
    }

    private boolean isWaystoneChunk(IWorld world, BlockPos pos) {
        int chunkDistance = (Integer)WaystoneConfig.COMMON.worldGenFrequency.get();
        int maxDeviation = (int)Math.ceil((float)chunkDistance / 2.0f);
        int chunkX = pos.func_177958_n() / 16;
        int chunkZ = pos.func_177952_p() / 16;
        int devGridX = pos.func_177958_n() / 16 * maxDeviation;
        int devGridZ = pos.func_177952_p() / 16 * maxDeviation;
        Random random = new Random(world.func_72905_C() * (long)devGridX * (long)devGridZ);
        int chunkOffsetX = random.nextInt(maxDeviation);
        int chunkOffsetZ = random.nextInt(maxDeviation);
        return (chunkX + chunkOffsetX) % chunkDistance == 0 && (chunkZ + chunkOffsetZ) % chunkDistance == 0;
    }
}

