/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.events;

import net.minecraft.block.BlockState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public abstract class RandomTickEvent<T>
extends Event {
    private final World world;
    private final BlockPos pos;
    private final T state;

    public RandomTickEvent(World world, BlockPos pos, T state) {
        this.world = world;
        this.pos = pos;
        this.state = state;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public T getState() {
        return this.state;
    }

    public static boolean onRandomTickBlock(World world, BlockPos pos, BlockState state) {
        return MinecraftForge.EVENT_BUS.post((Event)new Block(world, pos, state));
    }

    public static boolean onRandomTickFluid(World world, BlockPos pos, IFluidState state) {
        return MinecraftForge.EVENT_BUS.post((Event)new Fluid(world, pos, state));
    }

    @Cancelable
    public static class Fluid
    extends RandomTickEvent<IFluidState> {
        public Fluid(World world, BlockPos pos, IFluidState state) {
            super(world, pos, state);
        }
    }

    @Cancelable
    public static class Block
    extends RandomTickEvent<BlockState> {
        public Block(World world, BlockPos pos, BlockState state) {
            super(world, pos, state);
        }
    }
}

