/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.PendingCommand;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.SidedProvider;
import net.minecraftforge.fml.client.gui.screen.ConfirmationScreen;
import net.minecraftforge.fml.client.gui.screen.NotificationScreen;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class StartupQuery {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker SQ = MarkerManager.getMarker((String)"STARTUPQUERY");
    private InterruptedException exception;
    private static volatile StartupQuery pending;
    private static volatile boolean aborted;
    private String text;
    @Nullable
    private AtomicBoolean result;
    private CountDownLatch signal = new CountDownLatch(1);
    private volatile boolean synchronous;

    public static boolean confirm(String text) {
        StartupQuery query = new StartupQuery(text, new AtomicBoolean());
        query.execute();
        return query.getResult();
    }

    public static void notify(String text) {
        StartupQuery query = new StartupQuery(text, null);
        query.execute();
    }

    public static void abort() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.func_71263_m(false);
        }
        aborted = true;
        throw new AbortedException();
    }

    public static boolean pendingQuery() {
        return pending != null;
    }

    public static void reset() {
        pending = null;
        aborted = false;
    }

    public static boolean check() {
        if (pending != null) {
            try {
                try {
                    ((Consumer)SidedProvider.STARTUPQUERY.get()).accept(pending);
                }
                catch (RuntimeException e) {
                    LOGGER.error(SQ, "An exception occurred during startup query handling", (Throwable)e);
                }
                pending.throwException();
            }
            catch (InterruptedException e) {
                LOGGER.warn(SQ, "query interrupted");
                StartupQuery.abort();
            }
            pending = null;
        }
        return !aborted;
    }

    private void throwException() throws InterruptedException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private StartupQuery(String text, @Nullable AtomicBoolean result) {
        this.text = text;
        this.result = result;
    }

    @Nullable
    public Boolean getResult() {
        return this.result == null ? null : Boolean.valueOf(this.result.get());
    }

    public void setResult(boolean result) {
        this.result.set(result);
    }

    public String getText() {
        return this.text;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void finish() {
        this.signal.countDown();
    }

    private void execute() {
        String prop = System.getProperty("fml.queryResult");
        if (this.result != null && prop != null) {
            LOGGER.info(SQ, "Using fml.queryResult {} to answer the following query:\n{}", (Object)prop, (Object)this.text);
            if (prop.equalsIgnoreCase("confirm")) {
                this.setResult(true);
                return;
            }
            if (prop.equalsIgnoreCase("cancel")) {
                this.setResult(false);
                return;
            }
            LOGGER.warn(SQ, "Invalid value for fml.queryResult: {}, expected confirm or cancel", (Object)prop);
        }
        this.synchronous = false;
        pending = this;
        if (FMLEnvironment.dist.isDedicatedServer() || EffectiveSide.get() == LogicalSide.CLIENT) {
            this.synchronous = true;
            StartupQuery.check();
        }
        try {
            this.signal.await();
            StartupQuery.reset();
        }
        catch (InterruptedException e) {
            LOGGER.warn(SQ, "query interrupted");
            StartupQuery.abort();
        }
    }

    static {
        aborted = false;
    }

    public static class QueryWrapperServer {
        public static Consumer<StartupQuery> dedicatedServerQuery(Supplier<DedicatedServer> serverSupplier) {
            return query -> {
                DedicatedServer server = (DedicatedServer)serverSupplier.get();
                if (query.getResult() == null) {
                    LOGGER.warn(SQ, query.getText());
                    query.finish();
                } else {
                    String text = query.getText() + "\n\nRun the command /fml confirm or or /fml cancel to proceed.\nAlternatively start the server with -Dfml.queryResult=confirm or -Dfml.queryResult=cancel to preselect the answer.";
                    LOGGER.warn(SQ, text);
                    if (!query.isSynchronous()) {
                        return;
                    }
                    boolean done = false;
                    while (!done && server.func_71278_l()) {
                        if (Thread.interrupted()) {
                            ((StartupQuery)query).exception = new InterruptedException();
                            throw new RuntimeException();
                        }
                        DedicatedServer dedServer = server;
                        List list = dedServer.field_71341_l;
                        synchronized (list) {
                            Iterator it = dedServer.field_71341_l.iterator();
                            while (it.hasNext()) {
                                String cmd = ((PendingCommand)it.next()).field_73702_a.trim().toLowerCase();
                                String string = cmd = cmd.charAt(0) == '/' ? cmd.substring(1) : cmd;
                                if (cmd.equals("fml confirm")) {
                                    LOGGER.info(SQ, "confirmed");
                                    query.setResult(true);
                                    done = true;
                                    it.remove();
                                    continue;
                                }
                                if (cmd.equals("fml cancel")) {
                                    LOGGER.info(SQ, "cancelled");
                                    query.setResult(false);
                                    done = true;
                                    it.remove();
                                    continue;
                                }
                                if (!cmd.equals("stop")) continue;
                                StartupQuery.abort();
                            }
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            ((StartupQuery)query).exception = ie;
                        }
                    }
                    query.finish();
                }
            };
        }
    }

    public static class QueryWrapperClient {
        public static Consumer<StartupQuery> clientQuery(Supplier<Minecraft> clientSupplier) {
            return query -> {
                Minecraft client = (Minecraft)clientSupplier.get();
                if (query.getResult() == null) {
                    client.func_147108_a((Screen)new NotificationScreen((StartupQuery)query));
                } else {
                    client.func_147108_a((Screen)new ConfirmationScreen((StartupQuery)query));
                }
                if (query.isSynchronous()) {
                    while (client.field_71462_r instanceof NotificationScreen) {
                        if (Thread.interrupted()) {
                            ((StartupQuery)query).exception = new InterruptedException();
                            throw new RuntimeException();
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException ie) {
                            ((StartupQuery)query).exception = ie;
                        }
                    }
                }
            };
        }
    }

    public static class AbortedException
    extends RuntimeException {
        private static final long serialVersionUID = -5933665223696833921L;

        private AbortedException() {
        }
    }
}

