/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.maciej916.maenchants.capabilities.IEnchants;
import com.maciej916.maenchants.client.Keys;
import com.maciej916.maenchants.init.ModEnchants;
import com.maciej916.maenchants.network.Networking;
import com.maciej916.maenchants.network.PacketLumberjackToggle;
import com.maciej916.maenchants.utils.PlayerUtil;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.world.BlockEvent;

public class HandlerLumberjack {
    private static HashMultimap<PlayerEntity, BlockPos> treeMap = HashMultimap.create();

    @OnlyIn(value=Dist.CLIENT)
    public static void handlerKeyInput(Minecraft mc, InputEvent.KeyInputEvent event) {
        IEnchants enchantsCap = PlayerUtil.getAliveEnchantsCapability((PlayerEntity)mc.field_71439_g);
        if (enchantsCap == null) {
            return;
        }
        boolean down = Keys.excavateKey.func_151470_d();
        if (down) {
            if (!enchantsCap.getExcavateActive()) {
                enchantsCap.setExcavateActive(true);
                Networking.INSTANCE.sendToServer((Object)new PacketLumberjackToggle(true));
            }
        } else if (enchantsCap.getExcavateActive()) {
            enchantsCap.setExcavateActive(false);
            Networking.INSTANCE.sendToServer((Object)new PacketLumberjackToggle(false));
        }
    }

    public static void handlerBreak(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchants.LUMBERJACK, (ItemStack)stack) == 0) {
            return;
        }
        IEnchants enchantsCap = PlayerUtil.getAliveEnchantsCapability(player);
        if (enchantsCap == null) {
            return;
        }
        if (enchantsCap.getExcavateActive()) {
            BlockState state = event.getState();
            Block block = state.func_177230_c();
            if (!block.func_203417_a(BlockTags.field_200031_h)) {
                return;
            }
            World world = (World)event.getWorld();
            BlockPos pos = event.getPos();
            HandlerLumberjack.findTree(player, world, pos, state);
            if (treeMap.get((Object)player).size() < 512) {
                HandlerLumberjack.doBreak(player, world, pos);
                event.setCanceled(true);
            } else {
                treeMap.asMap().remove(player);
            }
        } else {
            treeMap.asMap().remove(player);
        }
    }

    public static void doBreak(PlayerEntity player, World world, BlockPos pos) {
        int logsBreak = 0;
        Block block = world.func_180495_p(pos).func_177230_c();
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        for (BlockPos point : ImmutableSet.copyOf((Collection)treeMap.get((Object)player))) {
            if (stack.func_77952_i() <= 0) break;
            ++logsBreak;
            world.func_175656_a(point, Blocks.field_150350_a.func_176223_P());
            stack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(player.func_184600_cs()));
        }
        ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)block, logsBreak));
        world.func_217376_c((Entity)item);
        treeMap.asMap().remove(player);
    }

    private static void findTree(PlayerEntity player, World world, BlockPos mine, BlockState state) {
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    boolean isLeaves;
                    BlockPos newPoint = mine.func_177982_a(offsetX, offsetY, offsetZ);
                    if (treeMap.containsEntry((Object)player, (Object)newPoint)) continue;
                    BlockState newBlockState = world.func_180495_p(newPoint);
                    boolean bl = isLeaves = newBlockState.func_185904_a() == Material.field_151584_j;
                    if (newBlockState.func_177230_c() != state.func_177230_c() || isLeaves) continue;
                    treeMap.put((Object)player, (Object)newPoint);
                    HandlerLumberjack.findTree(player, world, newPoint, state);
                }
            }
        }
    }
}

