/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants;

import com.maciej916.maenchants.capabilities.EnchantsProvider;
import com.maciej916.maenchants.capabilities.IEnchants;
import com.maciej916.maenchants.handler.HandlerBlazingWalker;
import com.maciej916.maenchants.handler.HandlerButchering;
import com.maciej916.maenchants.handler.HandlerCurseAquaphobia;
import com.maciej916.maenchants.handler.HandlerCurseBreaking;
import com.maciej916.maenchants.handler.HandlerCurseButterfingers;
import com.maciej916.maenchants.handler.HandlerCurseDeath;
import com.maciej916.maenchants.handler.HandlerDetonation;
import com.maciej916.maenchants.handler.HandlerFasterAttack;
import com.maciej916.maenchants.handler.HandlerFloating;
import com.maciej916.maenchants.handler.HandlerIceAspect;
import com.maciej916.maenchants.handler.HandlerLifesteal;
import com.maciej916.maenchants.handler.HandlerLumberjack;
import com.maciej916.maenchants.handler.HandlerMomentum;
import com.maciej916.maenchants.handler.HandlerMultiJump;
import com.maciej916.maenchants.handler.HandlerNightVision;
import com.maciej916.maenchants.handler.HandlerParalysis;
import com.maciej916.maenchants.handler.HandlerQuickDraw;
import com.maciej916.maenchants.handler.HandlerReinforcedTip;
import com.maciej916.maenchants.handler.HandlerStepAssist;
import com.maciej916.maenchants.handler.HandlerStoneMending;
import com.maciej916.maenchants.handler.HandlerTimeless;
import com.maciej916.maenchants.handler.HandlerTrueShot;
import com.maciej916.maenchants.utils.PlayerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ma-enchants", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("ma-enchants", "enchants"), (ICapabilityProvider)new EnchantsProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        IEnchants origEnchantsCap = PlayerUtil.getEnchantsCapability(event.getOriginal());
        IEnchants enchantsCap = PlayerUtil.getEnchantsCapability(event.getPlayer());
        enchantsCap.setVersion(origEnchantsCap.getVersion());
        enchantsCap.setStepAssist(origEnchantsCap.getStepAssist());
        enchantsCap.setNightVision(origEnchantsCap.getNightVision());
        enchantsCap.setMultiJump(origEnchantsCap.getMultiJump());
        enchantsCap.setMultiJumpSpace(origEnchantsCap.getMultiJumpSpace());
        enchantsCap.setExcavateActive(origEnchantsCap.getExcavateActive());
        System.out.println(enchantsCap);
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.ServerTickEvent event) {
        HandlerTrueShot.handlerWorldTick(event);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        World world = player.field_70170_p;
        if (!world.func_201670_d()) {
            HandlerBlazingWalker.handlerPlayerTick(player);
            HandlerCurseAquaphobia.handlerPlayerTick(event);
            HandlerCurseDeath.handlerPlayerTick(event);
        } else {
            HandlerMultiJump.handlerPlayerTick(event);
            HandlerNightVision.handlerPlayerTick(player);
            HandlerStepAssist.handlerPlayerTick(player);
            HandlerFasterAttack.handlerPlayerTick(player);
            HandlerQuickDraw.handlerPlayerTick(player);
        }
    }

    @SubscribeEvent
    public static void onAttack(LivingHurtEvent event) {
        HandlerLifesteal.handlerAttack(event);
        HandlerFloating.handlerAttack(event);
        HandlerParalysis.handlerAttack(event);
        HandlerIceAspect.handlerAttack(event);
        HandlerCurseButterfingers.handlerAttack(event);
        HandlerCurseBreaking.handlerAttack(event);
        HandlerButchering.handlerAttack(event);
        HandlerDetonation.handlerAttack(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        HandlerLumberjack.handlerBreak(event);
        HandlerMomentum.handlerBreak(event);
        HandlerStoneMending.handlerBreak(event);
        HandlerCurseBreaking.handlerBreak(event);
        HandlerCurseButterfingers.handlerBreak(event);
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        HandlerMomentum.handlerSpeed(event);
        HandlerReinforcedTip.handlerSpeed(event);
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        HandlerTrueShot.handlerSpawn(event);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)event.getPlayer();
        HandlerMultiJump.handlerLoggedIn(serverPlayer);
    }

    @SubscribeEvent
    public static void onItemDespawn(ItemExpireEvent event) {
        HandlerTimeless.handlerItemExpire(event);
    }
}

