/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.block.TileBase;
import owmii.lib.client.handler.IHudItem;
import owmii.lib.energy.SideConfig;
import owmii.lib.item.ItemBase;
import owmii.powah.api.wrench.IWrench;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.cable.EnergyCableBlock;
import owmii.powah.block.cable.EnergyCableTile;

public class WrenchItem
extends ItemBase
implements IHudItem,
IWrench {
    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, World world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, Vec3d hit) {
        if (player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IWrenchable) {
            if (((IWrenchable)state.func_177230_c()).onWrench(state, world, pos, player, hand, side, this.getWrenchMode(stack), hit)) {
                return ActionResultType.SUCCESS;
            }
        } else if (!world.field_72995_K && this.getWrenchMode(stack).config()) {
            TileBase.EnergyStorage storage;
            if (te instanceof EnergyCableTile) {
                EnergyCableTile cable = (EnergyCableTile)te;
                if (stack.func_77973_b() instanceof WrenchItem) {
                    Optional<Direction> sides = EnergyCableBlock.getHitSide(hit, pos);
                    boolean[] flag = new boolean[]{false};
                    sides.ifPresent(direction -> {
                        SideConfig config = cable.getSideConfig();
                        config.nextType(direction);
                        cable.markDirtyAndSync();
                    });
                    return ActionResultType.SUCCESS;
                }
            } else if (te instanceof TileBase.EnergyStorage && (storage = (TileBase.EnergyStorage)te).isEnergyPresent(side)) {
                SideConfig config = storage.getSideConfig();
                config.nextType(side);
                storage.markDirtyAndSync();
                return ActionResultType.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, world, pos, player, hand, side, hit);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            this.nextWrenchMode(stack);
            playerIn.func_146105_b(new TranslationTextComponent("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase(), new Object[]{TextFormatting.YELLOW}).func_211708_a(TextFormatting.GRAY), true);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase(), new Object[]{TextFormatting.YELLOW}).func_211708_a(TextFormatting.GRAY));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            this.oneTimeInfo(player, stack, new TranslationTextComponent("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase(), new Object[]{TextFormatting.YELLOW}).func_211708_a(TextFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(World world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, Vec3d hit) {
        return false;
    }

    private boolean changeWrenchMode(ItemStack stack, boolean next) {
        if (stack.func_77973_b() instanceof IWrench) {
            if (next) {
                this.nextWrenchMode(stack);
                return true;
            }
            this.prevWrenchMode(stack);
            return true;
        }
        return false;
    }

    private void nextWrenchMode(ItemStack stack) {
        int j;
        CompoundNBT nbt;
        int i = (nbt = this.getWrenchNBT(stack)).func_74762_e("WrenchMode") + 1;
        nbt.func_74768_a("WrenchMode", i > (j = WrenchMode.values().length - 1) ? 0 : i);
    }

    private void prevWrenchMode(ItemStack stack) {
        int j;
        CompoundNBT nbt;
        int i = (nbt = this.getWrenchNBT(stack)).func_74762_e("WrenchMode") - 1;
        nbt.func_74768_a("WrenchMode", i < (j = WrenchMode.values().length - 1) ? j : i);
    }

    @Override
    public WrenchMode getWrenchMode(ItemStack stack) {
        return WrenchMode.values()[this.getWrenchNBT(stack).func_74762_e("WrenchMode")];
    }

    public CompoundNBT getWrenchNBT(ItemStack stack) {
        return stack.func_190925_c("PowahWrenchNBT");
    }
}

