/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.client.util.RenderTypes;
import owmii.lib.item.EnergyBlockItem;
import owmii.lib.util.Player;
import owmii.powah.block.Tier;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.client.render.tile.ReactorRenderer;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ReactorItem
extends EnergyBlockItem<Tier, ReactorBlock> {
    static final ResourceLocation OV_TEXTURE = new ResourceLocation("powah", "textures/misc/reactor_ov.png");

    public ReactorItem(ReactorBlock block, Item.Properties properties, @Nullable ItemGroup group) {
        super((AbstractEnergyBlock)block, properties, group);
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        if (!context.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null || Player.isFake((PlayerEntity)player)) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = context.func_195996_i();
        if (stack.func_190916_E() < 36 && !player.func_184812_l_()) {
            player.func_146105_b(new TranslationTextComponent("chat.powah.not.enough.blocks", new Object[]{"" + TextFormatting.YELLOW + (36 - stack.func_190916_E()) + TextFormatting.RED}).func_211708_a(TextFormatting.RED), true);
            return ActionResultType.FAIL;
        }
        BlockPos pos = context.func_195995_a();
        List list = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 3, 1)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos blockPos : list) {
            if (context.func_195991_k().func_180495_p(blockPos).func_185904_a().func_76222_j()) continue;
            return ActionResultType.FAIL;
        }
        List entities = context.func_195991_k().func_217357_a(LivingEntity.class, new AxisAlignedBB(pos).func_72314_b(1.0, 3.0, 1.0));
        if (!entities.isEmpty()) {
            return ActionResultType.FAIL;
        }
        stack.func_190918_g(35);
        return super.func_195942_a(context);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderOv(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null || mc.field_71441_e == null) {
            return;
        }
        MatrixStack matrix = event.getMatrixStack();
        boolean flag = false;
        boolean flag1 = false;
        for (Hand hand : Hand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!(stack.func_77973_b() instanceof ReactorItem)) continue;
            flag = true;
            if (stack.func_190916_E() < 36) break;
            flag1 = true;
            break;
        }
        if (!flag) {
            return;
        }
        RayTraceResult result = mc.field_71476_x;
        if (result instanceof BlockRayTraceResult) {
            boolean isReplaceable;
            BlockRayTraceResult br = (BlockRayTraceResult)result;
            boolean bl = isReplaceable = mc.field_71441_e.func_180495_p(br.func_216350_a()).func_185904_a().func_76222_j() && !mc.field_71441_e.func_175623_d(br.func_216350_a());
            if (mc.field_71441_e.func_175623_d(br.func_216350_a()) || !isReplaceable && !br.func_216354_b().equals((Object)Direction.UP)) {
                return;
            }
            BlockPos pos = isReplaceable ? br.func_216350_a() : br.func_216350_a().func_177972_a(br.func_216354_b());
            List list = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 3, 1)).map(BlockPos::func_185334_h).collect(Collectors.toList());
            int color = 7725206;
            if (!flag1 && !player.func_184812_l_()) {
                color = 13566990;
            }
            if (color != 13566990) {
                List entities;
                for (BlockPos blockPos : list) {
                    if (mc.field_71441_e.func_180495_p(blockPos).func_185904_a().func_76222_j()) continue;
                    color = 13566990;
                    break;
                }
                if (!(entities = mc.field_71441_e.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos).func_72314_b(1.0, 3.0, 1.0))).isEmpty()) {
                    color = 13566990;
                }
            }
            matrix.func_227860_a_();
            Vec3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            matrix.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
            matrix.func_227861_a_(-1.0, 0.001, -1.0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.pushMatrix();
            IRenderTypeBuffer.Impl rtb = mc.func_228019_au_().func_228487_b_();
            IVertexBuilder buffer = rtb.getBuffer(RenderTypes.getTextBlended((ResourceLocation)OV_TEXTURE));
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            buffer.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 3)).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.0f, 1.0f).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), (float)(pos.func_177958_n() + 3), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 3)).func_227885_a_(r, g, b, 1.0f).func_225583_a_(1.0f, 1.0f).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), (float)(pos.func_177958_n() + 3), (float)pos.func_177956_o(), (float)pos.func_177952_p()).func_227885_a_(r, g, b, 1.0f).func_225583_a_(1.0f, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p()).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.0f, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
            rtb.func_228462_a_(RenderTypes.getTextBlended((ResourceLocation)OV_TEXTURE));
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.popMatrix();
            matrix.func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderByItem(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer rtb, int light, int ov) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227862_a_(1.0f, -1.0f, -1.0f);
        IVertexBuilder buffer = rtb.getBuffer(ReactorRenderer.CUBE_MODEL.func_228282_a_(new ResourceLocation("powah", "textures/model/tile/reactor_block_" + ((Tier)this.getVariant()).getName() + ".png")));
        ReactorRenderer.CUBE_MODEL.func_225598_a_(matrix, buffer, light, ov, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.func_227865_b_();
    }
}

