/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.solarpanel;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import owmii.lib.block.AbstractEnergyProviderBlock;
import owmii.lib.block.TileBase;
import owmii.lib.config.IEnergyProviderConfig;
import owmii.lib.energy.Energy;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.IVariant;
import owmii.powah.block.Tier;
import owmii.powah.block.solarpanel.SolarPanelTile;
import owmii.powah.config.Configs;
import owmii.powah.inventory.IContainers;
import owmii.powah.inventory.SolarPanelContainer;

public class SolarPanelBlock
extends AbstractEnergyProviderBlock<Tier>
implements IWaterLoggable {
    protected static final VoxelShape SHAPE = SolarPanelBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty OUTPUT = BooleanProperty.func_177716_a((String)"output");

    public SolarPanelBlock(Block.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
        this.setStateProps(state -> {
            BlockState cfr_ignored_0 = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)OUTPUT, (Comparable)Boolean.valueOf(false));
        });
    }

    public IEnergyProviderConfig<Tier> getEnergyConfig() {
        return Configs.SOLAR_PANEL;
    }

    public int stackSize() {
        return 1;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SolarPanelTile((Tier)this.variant);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase te, BlockRayTraceResult result) {
        if (te instanceof SolarPanelTile) {
            return new SolarPanelContainer(IContainers.SOLAR_PANEL, id, playerInventory, (SolarPanelTile)te);
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return this.createState(world, currentPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.createState((IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private BlockState createState(IWorld world, BlockPos pos) {
        BlockState state = this.func_176223_P();
        boolean north = this.canAttach(state, world, pos, Direction.NORTH);
        boolean south = this.canAttach(state, world, pos, Direction.SOUTH);
        boolean west = this.canAttach(state, world, pos, Direction.WEST);
        boolean east = this.canAttach(state, world, pos, Direction.EAST);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(!north))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(!south))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(!west))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(!east))).func_206870_a((IProperty)OUTPUT, (Comparable)Boolean.valueOf(Energy.isPresent((TileEntity)world.func_175625_s(pos.func_177977_b()), (Direction)Direction.DOWN)))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
    }

    public boolean canAttach(BlockState state, IWorld world, BlockPos pos, Direction direction) {
        return world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() == this;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, OUTPUT});
        super.func_206840_a(builder);
    }

    public List<Direction> getConnectedSides(BlockState state) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        if (!((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            list.add(Direction.NORTH);
        }
        if (!((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            list.add(Direction.SOUTH);
        }
        if (!((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            list.add(Direction.WEST);
        }
        if (!((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            list.add(Direction.EAST);
        }
        return list;
    }
}

