/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energydischarger;

import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import owmii.lib.block.TileBase;
import owmii.lib.energy.Energy;
import owmii.lib.util.IVariant;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.energydischarger.EnergyDischargerBlock;

public class EnergyDischargerTile
extends TileBase.EnergyStorage<Tier, EnergyDischargerBlock> {
    public EnergyDischargerTile(Tier variant) {
        super(ITiles.ENERGY_DISCHARGER, (IVariant)variant);
        this.inv.add(variant.ordinal() + 1);
    }

    public EnergyDischargerTile() {
        this(Tier.STARTER);
    }

    protected boolean postTicks(World world) {
        int[] extracted = new int[]{0};
        if (this.doWorkingTicks(world)) {
            for (int i = 0; i < this.inv.getSlots(); ++i) {
                ItemStack stack = this.inv.getStackInSlot(i);
                long amount = Math.min(this.getMaxEnergyExtract(), (long)Energy.getStored((ItemStack)stack));
                long received = Math.min(this.getEnergyCapacity() - this.getEnergyStored(), amount);
                int j = Energy.extract((ItemStack)stack, (long)received, (boolean)false);
                this.produceEnergy(j);
                extracted[0] = extracted[0] + j;
            }
        }
        return extracted[0] > 0 && super.postTicks(world);
    }

    public boolean canInsert(int index, ItemStack stack) {
        boolean[] b = new boolean[]{false};
        Energy.get((ItemStack)stack).ifPresent(storage -> {
            if (storage.canExtract()) {
                b[0] = storage.getEnergyStored() > 0;
            }
        });
        return b[0];
    }

    public boolean keepEnergy() {
        return true;
    }
}

