/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.naturesaura.recipes.ModRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TreeRitualRecipe
extends ModRecipe {
    public final Ingredient saplingType;
    public final Ingredient[] ingredients;
    public final ItemStack result;
    public final int time;

    public TreeRitualRecipe(ResourceLocation name, Ingredient saplingType, ItemStack result, int time, Ingredient ... ingredients) {
        super(name);
        this.saplingType = saplingType;
        this.ingredients = ingredients;
        this.result = result;
        this.time = time;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.TREE_RITUAL_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.TREE_RITUAL_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TreeRitualRecipe> {
        public TreeRitualRecipe read(ResourceLocation recipeId, JsonObject json) {
            ArrayList<Ingredient> ings = new ArrayList<Ingredient>();
            for (JsonElement element : json.getAsJsonArray("ingredients")) {
                ings.add(Ingredient.func_199802_a((JsonElement)element));
            }
            return new TreeRitualRecipe(recipeId, Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("sapling")), CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("output"), (boolean)true), json.get("time").getAsInt(), ings.toArray(new Ingredient[0]));
        }

        @Nullable
        public TreeRitualRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient[] ings = new Ingredient[buffer.readInt()];
            for (int i = 0; i < ings.length; ++i) {
                ings[i] = Ingredient.func_199566_b((PacketBuffer)buffer);
            }
            return new TreeRitualRecipe(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), buffer.func_150791_c(), buffer.readInt(), ings);
        }

        public void write(PacketBuffer buffer, TreeRitualRecipe recipe) {
            buffer.writeInt(recipe.ingredients.length);
            for (Ingredient ing : recipe.ingredients) {
                ing.func_199564_a(buffer);
            }
            recipe.saplingType.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
            buffer.writeInt(recipe.time);
        }
    }
}

