/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.EnergyUsage;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class DetailDataCollector
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final transient LongSupplier time;
    private final Map<Long, Data> data;

    @Deprecated
    public DetailDataCollector() {
        this(() -> 0L);
    }

    public DetailDataCollector(LongSupplier time) {
        this.time = time;
        this.data = new HashMap<Long, Data>();
    }

    public static DetailDataCollector getInstance(APowerTile tile) {
        if (Config.common().debug()) {
            return new DetailDataCollector(() -> Objects.requireNonNull(tile.func_145831_w()).func_82737_E());
        }
        return new Dummy();
    }

    public Data get() {
        return this.getOrCreateData(this.time.getAsLong());
    }

    public Data getOrCreateData(long tick) {
        return this.data.computeIfAbsent(tick, aLong -> new Data());
    }

    public void finish() {
        if (this.data.isEmpty()) {
            return;
        }
        Path parent = Paths.get("debug", "quarryplus");
        if (Files.notExists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                QuarryPlus.LOGGER.error("Errored creating directories.", (Throwable)e);
                return;
            }
        }
        LocalDateTime time = LocalDateTime.now();
        String name = time.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replace(':', '-');
        try {
            this.writeData(c -> {
                try {
                    Files.write(parent.resolve(name + ".csv"), (Iterable<? extends CharSequence>)c, new OpenOption[0]);
                }
                catch (IOException e) {
                    QuarryPlus.LOGGER.error("Errored writing file.", (Throwable)e);
                }
            }, Files.newOutputStream(parent.resolve(name + ".dat"), new OpenOption[0]));
        }
        catch (IOException e) {
            QuarryPlus.LOGGER.error("Errored writing file.", (Throwable)e);
        }
    }

    public void writeData(Consumer<List<String>> consumer, OutputStream stream) throws IOException {
        if (this.data.isEmpty()) {
            return;
        }
        Optional min = this.data.keySet().stream().min(Long::compareTo);
        List collect = this.data.entrySet().stream().map(e -> Pair.of((Object)((Long)e.getKey() - min.orElse(0L)), e.getValue())).sorted(Map.Entry.comparingByKey()).map(p -> p.getKey() + "," + (double)((Data)p.getValue()).energy / 1000000.0 + "," + p.getValue()).collect(Collectors.toList());
        collect.add(0, "Tick,Energy,Detail");
        consumer.accept(collect);
        try (ObjectOutputStream s = new ObjectOutputStream(stream);){
            s.writeObject(this);
        }
        this.data.clear();
    }

    public static final class Common
    implements EnergyDetail,
    Serializable {
        private static final long serialVersionUID = 280517939027947401L;
        private final EnergyUsage usage;
        private final long energy;

        public Common(EnergyUsage usage, long e) {
            this.usage = usage;
            this.energy = e;
        }

        public String toString() {
            return "Common{usage=" + (Object)((Object)this.usage) + " energy=" + (double)this.energy / 1000000.0 + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Common common = (Common)o;
            return Double.compare(common.energy, this.energy) == 0 && this.usage == common.usage;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.usage, this.energy});
        }

        @Override
        public long getEnergy() {
            return this.energy;
        }
    }

    public static class Pump
    implements EnergyDetail,
    Serializable {
        private static final long serialVersionUID = 6581044198335009551L;
        private final long amount;
        private final int u;
        private final long frame;
        private final long energy;

        public Pump(long amount, int u, long frame, long energy) {
            this.amount = amount;
            this.u = u;
            this.frame = frame;
            this.energy = energy;
        }

        public String toString() {
            return "Pump{amount=" + this.amount + " Un-breaking=" + this.u + " frame=" + this.frame + " e=" + (double)this.energy / 1000000.0 + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pump pump = (Pump)o;
            return this.amount == pump.amount && this.u == pump.u && this.frame == pump.frame;
        }

        public int hashCode() {
            return Objects.hash(this.amount, this.u, this.frame);
        }

        @Override
        public long getEnergy() {
            return this.energy;
        }
    }

    public static class Break
    implements EnergyDetail,
    Serializable {
        private static final long serialVersionUID = -6480496665210222175L;
        private final String name;
        private final float hardness;
        private final long e;

        public Break(BlockState block, float hardness, long e) {
            this.name = Objects.toString(block);
            this.hardness = hardness;
            this.e = e;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Break aBreak = (Break)o;
            return Float.compare(aBreak.hardness, this.hardness) == 0 && aBreak.e == this.e && this.name.equals(aBreak.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, Float.valueOf(this.hardness), this.e);
        }

        public String toString() {
            return "Break{name='" + this.name + '\'' + " hardness=" + this.hardness + " e=" + (double)this.e / 1000000.0 + '}';
        }

        @Override
        public long getEnergy() {
            return this.e;
        }
    }

    public static interface EnergyDetail {
        public long getEnergy();
    }

    public static class Data
    implements Serializable {
        private static final long serialVersionUID = 1466891218496509471L;
        long energy = 0L;
        private final List<EnergyDetail> others = new ArrayList<EnergyDetail>();

        public String toString() {
            return "Data{" + this.others.stream().map(Objects::toString).collect(Collectors.joining(" ")) + '}';
        }

        public void setEnergy(long energy) {
            this.energy = energy;
        }

        public void addData(EnergyDetail ... arg) {
            this.others.addAll(Arrays.asList(arg));
            long sum = Stream.of(arg).mapToLong(EnergyDetail::getEnergy).sum();
            this.setEnergy(this.energy + sum);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data data = (Data)o;
            return this.energy == data.energy && this.others.equals(data.others);
        }

        public int hashCode() {
            return Objects.hash(this.energy, this.others);
        }
    }

    private static class Dummy
    extends DetailDataCollector {
        private static final Data DATA = new DummyData();
        private static final long serialVersionUID = 8052625389652915615L;

        public Dummy() {
            super(() -> 0L);
        }

        @Override
        public Data get() {
            return DATA;
        }

        @Override
        public Data getOrCreateData(long tick) {
            return DATA;
        }

        @Override
        public void finish() {
        }

        @Override
        public void writeData(Consumer<List<String>> consumer, OutputStream stream) {
        }

        private static class DummyData
        extends Data {
            private static final long serialVersionUID = -2498801174658098984L;

            private DummyData() {
            }

            @Override
            public String toString() {
                return "DummyData";
            }

            @Override
            public void setEnergy(long energy) {
            }

            @Override
            public void addData(EnergyDetail ... arg) {
            }
        }
    }
}

