/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.ModItems;
import net.blay09.mods.refinedrelocation.ModTileEntities;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.filter.IMultiRootFilter;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.container.BlockExtenderContainer;
import net.blay09.mods.refinedrelocation.filter.RootFilter;
import net.blay09.mods.refinedrelocation.tile.IDroppableItemHandler;
import net.blay09.mods.refinedrelocation.tile.TileMod;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileBlockExtender
extends TileMod
implements ITickableTileEntity,
INamedContainerProvider,
IDroppableItemHandler,
IMultiRootFilter {
    private final ItemStackHandler itemHandlerUpgrades = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!TileBlockExtender.this.isUpgradeItem(stack)) {
                return false;
            }
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_77973_b() != stack.func_77973_b()) continue;
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileBlockExtender.this.updateUpgrades();
            TileBlockExtender.this.func_70296_d();
        }
    };
    private final Direction[] sideMappings = new Direction[5];
    private final IRootFilter inputFilter = new RootFilter();
    private final IRootFilter outputFilter = new RootFilter();
    private int stackLimiterLimit = 64;
    private boolean hasStackLimiter;
    private boolean hasSlotLock;
    private boolean hasInputFilter;
    private boolean hasOutputFilter;
    private TileEntity cachedConnectedTile;
    private final ItemHandlerWrapper[] cachedItemHandlers = new ItemHandlerWrapper[6];
    private final Direction[] cachedFacingToFacingMappings = new Direction[6];

    private boolean isUpgradeItem(ItemStack stack) {
        return stack.func_77973_b() == ModItems.stackLimiter || stack.func_77973_b() == ModItems.outputFilter || stack.func_77973_b() == ModItems.inputFilter || stack.func_77973_b() == ModItems.slotLock;
    }

    public TileBlockExtender() {
        super(ModTileEntities.blockExtender);
    }

    @Override
    public IRootFilter getRootFilter(int index) {
        return index == 0 ? this.inputFilter : this.outputFilter;
    }

    @Nullable
    public Direction getSideMapping(RelativeSide side) {
        return this.sideMappings[side.ordinal()];
    }

    public void setSideMapping(RelativeSide side, @Nullable Direction facing) {
        this.sideMappings[side.ordinal()] = facing;
        this.cachedFacingToFacingMappings[side.toFacing((Direction)this.getFacing()).ordinal()] = facing;
        this.func_70296_d();
    }

    public void func_73660_a() {
        this.baseTick();
        if (this.cachedConnectedTile == null) {
            this.cachedConnectedTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        } else if (this.cachedConnectedTile.func_145837_r()) {
            this.cachedConnectedTile = null;
        }
    }

    @Override
    protected void onFirstTick() {
        this.cachedConnectedTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (this.cachedConnectedTile instanceof TileBlockExtender) {
            this.cachedConnectedTile = null;
        }
        for (int i = 0; i < this.sideMappings.length; ++i) {
            this.cachedFacingToFacingMappings[RelativeSide.fromIndex((int)i).toFacing((Direction)this.getFacing()).ordinal()] = this.sideMappings[i];
        }
        this.updateUpgrades();
    }

    @Nullable
    public Direction getSideMapping(@Nullable Direction facing) {
        if (facing == null) {
            return this.getFacing().func_176734_d();
        }
        return this.cachedFacingToFacingMappings[facing.ordinal()];
    }

    public Direction getFacing() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        byte[] mappings = new byte[5];
        for (int i = 0; i < this.sideMappings.length; ++i) {
            mappings[i] = (byte)(this.sideMappings[i] == null ? -1 : (byte)this.sideMappings[i].func_176745_a());
        }
        compound.func_74773_a("SideMappings", mappings);
        compound.func_218657_a("Upgrades", (INBT)this.itemHandlerUpgrades.serializeNBT());
        compound.func_74774_a("StackLimiter", (byte)this.stackLimiterLimit);
        compound.func_218657_a("InputFilter", this.inputFilter.serializeNBT());
        compound.func_218657_a("OutputFilter", this.outputFilter.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        byte[] mappings = compound.func_74770_j("SideMappings");
        if (mappings.length == 5) {
            for (int i = 0; i < mappings.length; ++i) {
                this.sideMappings[i] = mappings[i] != -1 ? Direction.func_82600_a((int)mappings[i]) : null;
            }
        }
        this.itemHandlerUpgrades.deserializeNBT(compound.func_74775_l("Upgrades"));
        this.stackLimiterLimit = compound.func_74771_c("StackLimiter");
        this.inputFilter.deserializeNBT((INBT)compound.func_74775_l("InputFilter"));
        this.outputFilter.deserializeNBT((INBT)compound.func_74775_l("OutputFilter"));
        this.updateUpgrades();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction ioSide;
        if (cap == Capabilities.MULTI_ROOT_FILTER) {
            return LazyOptional.of(() -> this).cast();
        }
        if (this.cachedConnectedTile != null && (ioSide = this.getSideMapping(side)) != null) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.requiresItemHandlerWrapping()) {
                int cacheIdx = ioSide.func_176745_a();
                if (this.cachedItemHandlers[cacheIdx] != null) {
                    if (!this.cachedItemHandlers[cacheIdx].revalidate()) {
                        this.cachedItemHandlers[cacheIdx] = null;
                        return LazyOptional.empty();
                    }
                } else {
                    LazyOptional itemHandlerCap = this.cachedConnectedTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ioSide);
                    itemHandlerCap.ifPresent(itemHandler -> {
                        this.cachedItemHandlers[cacheIdx] = new ItemHandlerWrapper(this.cachedConnectedTile, ioSide, (IItemHandler)itemHandler);
                    });
                }
                return LazyOptional.of(() -> this.cachedItemHandlers[cacheIdx]).cast();
            }
            return this.cachedConnectedTile.getCapability(cap, ioSide);
        }
        return super.getCapability(cap, side);
    }

    private boolean requiresItemHandlerWrapping() {
        return this.hasStackLimiter || this.hasSlotLock || this.hasInputFilter || this.hasOutputFilter;
    }

    @Override
    public String getUnlocalizedName() {
        return "container.refinedrelocation:block_extender";
    }

    public ItemStackHandler getItemHandlerUpgrades() {
        return this.itemHandlerUpgrades;
    }

    private void updateUpgrades() {
        this.hasStackLimiter = false;
        this.hasSlotLock = false;
        this.hasInputFilter = false;
        this.hasOutputFilter = false;
        for (int i = 0; i < this.itemHandlerUpgrades.getSlots(); ++i) {
            ItemStack itemStack = this.itemHandlerUpgrades.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() == ModItems.stackLimiter) {
                this.hasStackLimiter = true;
                continue;
            }
            if (itemStack.func_77973_b() == ModItems.slotLock) {
                this.hasSlotLock = true;
                continue;
            }
            if (itemStack.func_77973_b() == ModItems.inputFilter) {
                this.hasInputFilter = true;
                continue;
            }
            if (itemStack.func_77973_b() != ModItems.outputFilter) continue;
            this.hasOutputFilter = true;
        }
    }

    @Override
    public Collection<IItemHandler> getDroppedItemHandlers() {
        return Collections.singletonList(this.itemHandlerUpgrades);
    }

    public int getStackLimiterLimit() {
        return this.stackLimiterLimit;
    }

    public void setStackLimiterLimit(int stackLimiterLimit) {
        this.stackLimiterLimit = stackLimiterLimit;
    }

    public LazyOptional<IRootFilter> getInputFilter() {
        return LazyOptional.of(() -> this.inputFilter);
    }

    public LazyOptional<IRootFilter> getOutputFilter() {
        return LazyOptional.of(() -> this.outputFilter);
    }

    public boolean hasInputFilter() {
        return this.hasInputFilter;
    }

    public boolean hasOutputFilter() {
        return this.hasOutputFilter;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getUnlocalizedName(), new Object[0]);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BlockExtenderContainer(i, playerInventory, this);
    }

    private class ItemHandlerWrapper
    implements IItemHandler {
        private final TileEntity tileEntity;
        private final Direction facing;
        private IItemHandler baseHandler;

        public ItemHandlerWrapper(@Nullable TileEntity tileEntity, Direction facing, IItemHandler baseHandler) {
            this.tileEntity = tileEntity;
            this.facing = facing;
            this.baseHandler = baseHandler;
        }

        public boolean revalidate() {
            LazyOptional itemHandlerCap = this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing);
            itemHandlerCap.ifPresent(itemHandler -> {
                this.baseHandler = itemHandler;
            });
            return itemHandlerCap.isPresent();
        }

        public int getSlots() {
            return this.baseHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.baseHandler.getStackInSlot(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (TileBlockExtender.this.hasSlotLock && (stack.func_190926_b() || this.getStackInSlot(slot).func_190926_b())) {
                return false;
            }
            return !TileBlockExtender.this.hasInputFilter || !stack.func_190926_b() && TileBlockExtender.this.inputFilter.passes(this.tileEntity, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (TileBlockExtender.this.hasStackLimiter) {
                int space = TileBlockExtender.this.stackLimiterLimit - this.getStackInSlot(slot).func_190916_E();
                if (space <= 0) {
                    return stack;
                }
                int amount = Math.min(stack.func_190916_E(), space);
                if (amount < stack.func_190916_E()) {
                    ItemStack insertStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
                    ItemStack restStack = this.baseHandler.insertItem(slot, insertStack, simulate);
                    int initialRest = stack.func_190916_E() - amount;
                    if (initialRest > 0) {
                        ItemStack otherRestStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)initialRest);
                        if (restStack.func_190926_b()) {
                            return otherRestStack;
                        }
                        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)restStack)) {
                            restStack.func_190917_f(initialRest);
                        } else if (!((TileBlockExtender)TileBlockExtender.this).field_145850_b.field_72995_K) {
                            TileBlockExtender.this.field_145850_b.func_217376_c((Entity)new ItemEntity(TileBlockExtender.this.field_145850_b, (double)TileBlockExtender.this.field_174879_c.func_177958_n() + 0.5, (double)TileBlockExtender.this.field_174879_c.func_177956_o() + 0.5, (double)TileBlockExtender.this.field_174879_c.func_177952_p() + 0.5, otherRestStack));
                        }
                    }
                    return restStack;
                }
            }
            return this.baseHandler.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileBlockExtender.this.hasOutputFilter && !TileBlockExtender.this.outputFilter.passes(this.tileEntity, this.getStackInSlot(slot))) {
                return ItemStack.field_190927_a;
            }
            return this.baseHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.baseHandler.getSlots();
        }
    }
}

