/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.SortingChestType;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.container.SortingChestContainer;
import net.blay09.mods.refinedrelocation.tile.TileMod;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SortingChestTileEntity
extends TileMod
implements ITickableTileEntity,
INamedContainerProvider,
INameable,
IChestLid,
IClearable {
    private static final int EVENT_NUM_PLAYERS = 1;
    private final ItemStackHandler itemHandler;
    private final ISortingInventory sortingInventory = Capabilities.getDefaultInstance(Capabilities.SORTING_INVENTORY);
    private final IRootFilter rootFilter = Capabilities.getDefaultInstance(Capabilities.ROOT_FILTER);
    private final SortingChestType chestType;
    private float lidAngle;
    private float prevLidAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private ITextComponent customName;

    public SortingChestTileEntity(SortingChestType chestType) {
        super(chestType.getTileEntityType());
        this.chestType = chestType;
        this.itemHandler = new ItemStackHandler(chestType.getInventorySize()){

            protected void onContentsChanged(int slot) {
                SortingChestTileEntity.this.func_70296_d();
                SortingChestTileEntity.this.sortingInventory.onSlotChanged(slot);
            }
        };
    }

    public SortingChestType getChestType() {
        return this.chestType;
    }

    @Override
    public void onFirstTick() {
        this.sortingInventory.onFirstTick(this);
    }

    public void func_73660_a() {
        this.baseTick();
        this.sortingInventory.onUpdate(this);
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + this.field_174879_c.func_177958_n() + this.field_174879_c.func_177956_o() + this.field_174879_c.func_177952_p()) % 200 == 0) {
            this.numPlayersUsing = this.calculatePlayersUsing();
        }
        this.prevLidAngle = this.lidAngle;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float oldLidAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && oldLidAngle >= 0.5f) {
                this.field_145850_b.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    private int calculatePlayersUsing() {
        int result = 0;
        float distance = 5.0f;
        for (PlayerEntity player : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - distance), (double)((float)this.field_174879_c.func_177956_o() - distance), (double)((float)this.field_174879_c.func_177952_p() - distance), (double)((float)(this.field_174879_c.func_177958_n() + 1) + distance), (double)((float)(this.field_174879_c.func_177956_o() + 1) + distance), (double)((float)(this.field_174879_c.func_177952_p() + 1) + distance)))) {
            if (!(player.field_71070_bA instanceof SortingChestContainer) || ((SortingChestContainer)player.field_71070_bA).getTileEntity() != this) continue;
            ++result;
        }
        return result;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.sortingInventory.onInvalidate(this);
    }

    public void onChunkUnloaded() {
        this.sortingInventory.onInvalidate(this);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        CompoundNBT itemHandlerCompound = compound.func_74775_l("ItemHandler");
        itemHandlerCompound.func_74768_a("Size", this.chestType.getInventorySize());
        this.itemHandler.deserializeNBT(itemHandlerCompound);
        this.sortingInventory.deserializeNBT((INBT)compound.func_74775_l("SortingInventory"));
        this.rootFilter.deserializeNBT((INBT)compound.func_74775_l("RootFilter"));
        this.customName = compound.func_74764_b("CustomName") ? new StringTextComponent(compound.func_74779_i("CustomName")) : null;
    }

    @Override
    public void readFromNBTSynced(CompoundNBT compound) {
        this.setCustomName(compound.func_74779_i("CustomName"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        compound.func_218657_a("SortingInventory", this.sortingInventory.serializeNBT());
        compound.func_218657_a("RootFilter", this.rootFilter.serializeNBT());
        if (this.customName != null) {
            compound.func_74778_a("CustomName", this.customName.func_150261_e());
        }
        return compound;
    }

    @Override
    public CompoundNBT writeToNBTSynced(CompoundNBT compound) {
        if (this.customName != null) {
            compound.func_74778_a("CustomName", this.customName.func_150261_e());
        }
        return compound;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional result = super.getCapability(cap, side);
        if (!result.isPresent()) {
            result = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.itemHandler));
        }
        if (!result.isPresent()) {
            result = Capabilities.SORTING_GRID_MEMBER.orEmpty(cap, LazyOptional.of(() -> this.sortingInventory));
        }
        if (!result.isPresent()) {
            result = Capabilities.SORTING_INVENTORY.orEmpty(cap, LazyOptional.of(() -> this.sortingInventory));
        }
        if (!result.isPresent()) {
            result = Capabilities.ROOT_FILTER.orEmpty(cap, LazyOptional.of(() -> this.rootFilter));
        }
        if (!result.isPresent()) {
            result = Capabilities.SIMPLE_FILTER.orEmpty(cap, LazyOptional.of(() -> this.rootFilter));
        }
        return result;
    }

    @Override
    public String getUnlocalizedName() {
        return "container.refinedrelocation:" + this.chestType.getRegistryName();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getUnlocalizedName(), new Object[0]);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new SortingChestContainer(i, playerInventory, this);
    }

    public void setCustomName(String customName) {
        this.customName = new StringTextComponent(customName);
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : new TranslationTextComponent(this.getUnlocalizedName(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    public void openChest(PlayerEntity player) {
        if (!player.func_175149_v()) {
            this.numPlayersUsing = Math.max(0, this.numPlayersUsing + 1);
            this.field_145850_b.func_175641_c(this.field_174879_c, Blocks.field_150477_bB, 1, this.numPlayersUsing);
        }
    }

    public void closeChest(PlayerEntity player) {
        if (!player.func_175149_v()) {
            this.numPlayersUsing = Math.max(0, this.numPlayersUsing - 1);
            this.field_145850_b.func_175641_c(this.field_174879_c, Blocks.field_150477_bB, 1, this.numPlayersUsing);
        }
    }

    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public int getNumPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void restoreItems(ListNBT items) {
        for (INBT item : items) {
            ItemStack itemStack;
            CompoundNBT compound = (CompoundNBT)item;
            byte slot = compound.func_74771_c("Slot");
            ItemStack rest = this.itemHandler.insertItem((int)slot, itemStack = ItemStack.func_199557_a((CompoundNBT)compound), false);
            if (rest.func_190926_b()) continue;
            this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)this.field_174879_c.func_177952_p() + 0.5, rest));
        }
    }

    public void func_174888_l() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }
}

