/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.network;

import java.util.function.Supplier;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.api.container.IContainerNetworked;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class MessageContainer
implements IContainerMessage {
    protected final String key;

    public MessageContainer(String key) {
        this.key = key;
    }

    public static void handle(MessageContainer message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
                Container container;
                ServerPlayerEntity player = context.getSender();
                if (player != null && (container = player.field_71070_bA) instanceof IContainerNetworked) {
                    ((IContainerNetworked)container).receivedMessageServer(message);
                }
            } else {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
                    if (container instanceof IContainerNetworked) {
                        ((IContainerNetworked)container).receivedMessageClient(message);
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }

    @Override
    public String getKey() {
        return this.key;
    }
}

