/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.grid;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.filter.ISimpleFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingGrid;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.grid.SortingGridMember;
import net.blay09.mods.refinedrelocation.grid.SortingStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SortingInventory
extends SortingGridMember
implements ISortingInventory {
    private final LinkedList<SortingStack> sortingStackList = Lists.newLinkedList();
    private LazyOptional<? extends ISimpleFilter> filter;
    private int priority;

    @Override
    public LazyOptional<IItemHandler> getItemHandler() {
        return this.getTileEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public LazyOptional<? extends ISimpleFilter> getFilter() {
        return this.filter;
    }

    @Override
    protected void onLoad() {
        super.onLoad();
        this.filter = this.getTileEntity().getCapability(CapabilityRootFilter.CAPABILITY);
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        if (!this.sortingStackList.isEmpty()) {
            SortingStack sortingStack = this.sortingStackList.removeFirst();
            ISortingGrid sortingGrid = this.getSortingGrid();
            if (sortingGrid != null) {
                sortingGrid.setSortingActive(true);
                ItemStack itemStack = sortingStack.getItemHandler().getStackInSlot(sortingStack.getSlotIndex());
                if (ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)sortingStack.getItemStack()) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)sortingStack.getItemStack())) {
                    RefinedRelocationAPI.insertIntoSortingGrid(this, sortingStack.getSlotIndex(), itemStack);
                }
                sortingGrid.setSortingActive(false);
            }
        }
    }

    @Override
    public void onSlotChanged(int slotIndex) {
        if (this.getSortingGrid() == null || this.getSortingGrid().isSortingActive() || this.isRemote()) {
            return;
        }
        LazyOptional<IItemHandler> itemHandlerCap = this.getItemHandler();
        itemHandlerCap.ifPresent(itemHandler -> {
            ItemStack itemStack = itemHandler.getStackInSlot(slotIndex);
            if (!itemStack.func_190926_b()) {
                this.sortingStackList.add(new SortingStack((IItemHandler)itemHandler, slotIndex, itemStack));
            }
        });
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74777_a("Priority", (short)this.priority);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.priority = compound.func_74765_d("Priority");
    }
}

