/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import invtweaks.api.container.ChestContainer;
import net.blay09.mods.refinedrelocation.SortingChestType;
import net.blay09.mods.refinedrelocation.container.BaseContainer;
import net.blay09.mods.refinedrelocation.container.ModContainers;
import net.blay09.mods.refinedrelocation.tile.SortingChestTileEntity;
import net.blay09.mods.refinedrelocation.util.IContainerWithDoor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

@ChestContainer
public class SortingChestContainer
extends BaseContainer
implements IContainerWithDoor {
    private final SortingChestTileEntity tileEntity;

    public SortingChestContainer(int windowId, PlayerInventory playerInventory, SortingChestTileEntity tileEntity) {
        super(ModContainers.sortingChest, windowId);
        this.tileEntity = tileEntity;
        SortingChestType chestType = tileEntity.getChestType();
        int rowSize = chestType.getContainerRowSize();
        int rowCount = chestType.getInventorySize() / rowSize;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < rowSize; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.getItemHandler(), j + i * rowSize, 8 + j * 18, 18 + i * 18));
            }
        }
        this.addPlayerInventory(playerInventory, (chestType.getGuiWidth() - 162) / 2 + 1, rowCount * 18 + 32);
        tileEntity.openChest(playerInventory.field_70458_d);
    }

    public SortingChestTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            int inventoryStartIndex = this.tileEntity.getChestType().getInventorySize();
            if (index < inventoryStartIndex ? !this.func_75135_a(slotStack, inventoryStartIndex, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, inventoryStartIndex, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        return !this.tileEntity.func_145837_r() && player.func_70092_e((double)this.tileEntity.func_174877_v().func_177958_n() + 0.5, (double)this.tileEntity.func_174877_v().func_177956_o() + 0.5, (double)this.tileEntity.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean isTileEntity(TileEntity tileEntity) {
        return this.tileEntity == tileEntity;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.tileEntity.closeChest(player);
    }
}

