/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.blay09.mods.refinedrelocation.client.gui.base.ITooltipElement;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiImageButton;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TextFormatting;

public class GuiSideButton
extends GuiImageButton
implements ITooltipElement {
    private final TileBlockExtender tileEntity;
    private final RelativeSide side;

    public GuiSideButton(int x, int y, TileBlockExtender tileEntity, RelativeSide side) {
        super(x, y, 16, 16, GuiTextures.SIDE_BUTTONS[side.ordinal()], it -> {});
        this.tileEntity = tileEntity;
        this.side = side;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.onClick(mouseX, mouseY, mouseButton);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void onClick(double mouseX, double mouseY, int mouseButton) {
        int index;
        if (this.side == RelativeSide.FRONT) {
            if (Screen.hasShiftDown()) {
                for (RelativeSide side : RelativeSide.values()) {
                    if (side == RelativeSide.FRONT) continue;
                    this.tileEntity.setSideMapping(side, null);
                    RefinedRelocationAPI.sendContainerMessageToServer("ToggleSide", side.ordinal(), -1);
                }
            }
            return;
        }
        Object facing = this.tileEntity.getSideMapping(this.side);
        if (mouseButton == 0) {
            index = facing != null ? facing.func_176745_a() + 1 : 0;
        } else if (mouseButton == 1) {
            index = facing != null ? facing.func_176745_a() - 1 : 5;
        } else {
            return;
        }
        facing = index >= 6 ? null : (index < 0 ? null : Direction.func_82600_a((int)index));
        this.tileEntity.setSideMapping(this.side, (Direction)facing);
        RefinedRelocationAPI.sendContainerMessageToServer("ToggleSide", this.side.ordinal(), facing != null ? facing.func_176745_a() : -1);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.side != RelativeSide.FRONT) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            char sideChar = this.getFacingChar(this.tileEntity.getSideMapping(this.side));
            float labelX = (float)this.x + (float)this.width / 2.0f - (float)fontRenderer.func_78256_a(String.valueOf(sideChar)) / 2.0f;
            float f = (float)this.y + (float)this.height / 2.0f;
            fontRenderer.getClass();
            float labelY = f - 9.0f / 2.0f;
            RenderSystem.translatef((float)0.5f, (float)0.5f, (float)0.0f);
            fontRenderer.func_211126_b(String.valueOf(sideChar), labelX, labelY, -1);
            RenderSystem.translatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        }
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        super.renderButton(mouseX, mouseY, partialTicks);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.side == RelativeSide.FRONT) {
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.front", (Object[])new Object[0]));
        } else {
            Direction mapping = this.tileEntity.getSideMapping(this.side);
            list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.side_tooltip", (Object[])new Object[]{TextFormatting.WHITE + I18n.func_135052_a((String)("gui.refinedrelocation:block_extender.side_" + (mapping != null ? mapping.func_176610_l() : "none")), (Object[])new Object[0])}));
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.toggle_side", (Object[])new Object[0]));
        }
    }

    private char getFacingChar(@Nullable Direction facing) {
        if (facing == null) {
            return '-';
        }
        switch (facing) {
            case DOWN: {
                return 'D';
            }
            case UP: {
                return 'U';
            }
            case WEST: {
                return 'W';
            }
            case EAST: {
                return 'E';
            }
            case NORTH: {
                return 'N';
            }
            case SOUTH: {
                return 'S';
            }
        }
        return ' ';
    }
}

