/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import net.blay09.mods.refinedrelocation.api.Priority;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.client.gui.base.ITickableElement;
import net.blay09.mods.refinedrelocation.client.gui.base.ITooltipElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiButtonPriority
extends Button
implements ITooltipElement,
ITickableElement {
    private static final Priority.Enum[] values = Priority.Enum.values();
    private final ISortingInventory sortingInventory;
    private int currentIndex = 2;

    public GuiButtonPriority(int x, int y, int width, int height, ISortingInventory sortingInventory) {
        super(x, y, width, height, I18n.func_135052_a((String)values[2].getLangKey(), (Object[])new Object[0]), it -> {});
        this.sortingInventory = sortingInventory;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.onClick(mouseX, mouseY, mouseButton);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void onClick(double mouseX, double mouseY, int mouseButton) {
        if (!Screen.hasShiftDown()) {
            int oldIndex;
            int n = oldIndex = this.currentIndex != -1 ? this.currentIndex : (this.sortingInventory.getPriority() + 1000) / 500;
            if (mouseButton == 0) {
                ++oldIndex;
            } else if (mouseButton == 1) {
                --oldIndex;
            }
            this.currentIndex = Math.max(0, Math.min(values.length - 1, oldIndex));
            this.setMessage(I18n.func_135052_a((String)values[this.currentIndex].getLangKey(), (Object[])new Object[0]));
            this.sortingInventory.setPriority(values[this.currentIndex].getPriority());
        } else {
            this.currentIndex = -1;
            int oldPriority = this.sortingInventory.getPriority();
            if (mouseButton == 0) {
                oldPriority += 10;
            } else if (mouseButton == 1) {
                oldPriority -= 10;
            }
            oldPriority = Math.max(-999, Math.min(999, oldPriority));
            this.sortingInventory.setPriority(oldPriority);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        this.currentIndex = -1;
        int oldPriority = this.sortingInventory.getPriority();
        if (delta > 0.0) {
            ++oldPriority;
        } else if (delta < 0.0) {
            --oldPriority;
        }
        oldPriority = Math.max(-999, Math.min(999, oldPriority));
        this.sortingInventory.setPriority(oldPriority);
        return true;
    }

    @Override
    public void tick() {
        this.currentIndex = -1;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].getPriority() != this.sortingInventory.getPriority()) continue;
            this.currentIndex = i;
            break;
        }
        this.setMessage(this.currentIndex != -1 ? I18n.func_135052_a((String)values[this.currentIndex].getLangKey(), (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.priority_custom", (Object[])new Object[]{this.sortingInventory.getPriority()}));
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!Screen.hasShiftDown()) {
            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.priority_increase", (Object[])new Object[0]));
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.priority_decrease", (Object[])new Object[0]));
        } else {
            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.priority_increase10", (Object[])new Object[0]));
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.priority_decrease10", (Object[])new Object[0]));
        }
        if (this.currentIndex != -1) {
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.priority_tooltip", (Object[])new Object[]{values[this.currentIndex].getPriority()}));
        }
    }
}

