/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocationUtils;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.InternalMethods;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.ISimpleFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingGrid;
import net.blay09.mods.refinedrelocation.api.grid.ISortingGridMember;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiOpenFilterButton;
import net.blay09.mods.refinedrelocation.filter.FilterRegistry;
import net.blay09.mods.refinedrelocation.grid.SortingGrid;
import net.blay09.mods.refinedrelocation.network.MessageContainer;
import net.blay09.mods.refinedrelocation.network.MessageContainerByteArray;
import net.blay09.mods.refinedrelocation.network.MessageContainerIndexedInt;
import net.blay09.mods.refinedrelocation.network.MessageContainerInt;
import net.blay09.mods.refinedrelocation.network.MessageContainerNBT;
import net.blay09.mods.refinedrelocation.network.MessageContainerString;
import net.blay09.mods.refinedrelocation.network.MessageFilterPreview;
import net.blay09.mods.refinedrelocation.network.MessageRequestFilterGUI;
import net.blay09.mods.refinedrelocation.network.MessageReturnGUI;
import net.blay09.mods.refinedrelocation.network.NetworkHandler;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InternalMethodsImpl
implements InternalMethods {
    @Override
    public void registerFilter(Class<? extends IFilter> filterClass) {
        FilterRegistry.registerFilter(filterClass);
    }

    @Override
    public void addToSortingGrid(ISortingGridMember member) {
        ISortingGrid sortingGrid = member.getSortingGrid();
        if (sortingGrid != null) {
            return;
        }
        World world = member.getTileEntity().func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = member.getTileEntity().func_174877_v();
        for (Direction facing : Direction.values()) {
            ISortingGridMember otherMember;
            TileEntity tileEntity;
            BlockPos facingPos = pos.func_177972_a(facing);
            if (!world.func_175667_e(facingPos) || (tileEntity = world.func_217349_x(facingPos).func_175625_s(facingPos)) == null || (otherMember = (ISortingGridMember)RefinedRelocationUtils.orNull(tileEntity.getCapability(Capabilities.SORTING_GRID_MEMBER, facing.func_176734_d()))) == null || otherMember.getSortingGrid() == null) continue;
            if (sortingGrid != null) {
                ((SortingGrid)sortingGrid).mergeWith(otherMember.getSortingGrid());
                continue;
            }
            sortingGrid = otherMember.getSortingGrid();
        }
        if (sortingGrid == null) {
            sortingGrid = new SortingGrid();
        }
        sortingGrid.addMember(member);
    }

    @Override
    public void removeFromSortingGrid(ISortingGridMember member) {
        ISortingGrid sortingGrid = member.getSortingGrid();
        if (sortingGrid == null) {
            return;
        }
        sortingGrid.removeMember(member);
        for (ISortingGridMember otherMember : sortingGrid.getMembers()) {
            otherMember.setSortingGrid(null);
        }
        for (ISortingGridMember otherMember : sortingGrid.getMembers()) {
            RefinedRelocationAPI.addToSortingGrid(otherMember);
        }
    }

    @Override
    public void insertIntoSortingGrid(ISortingInventory sortingInventory, int fromSlotIndex, ItemStack itemStack) {
        ISortingInventory targetInventory;
        ArrayList passingList = Lists.newArrayList();
        IItemHandler itemHandler = RefinedRelocationUtils.orNull(sortingInventory.getItemHandler());
        if (itemHandler == null) {
            return;
        }
        ItemStack restStack = itemHandler.extractItem(fromSlotIndex, Items.field_190931_a.getItemStackLimit(ItemStack.field_190927_a), true);
        if (restStack.func_190926_b()) {
            return;
        }
        ISortingGrid sortingGrid = sortingInventory.getSortingGrid();
        if (sortingGrid != null) {
            for (ISortingGridMember member : sortingGrid.getMembers()) {
                ItemStack testStack;
                ISortingInventory memberInventory;
                LazyOptional<? extends ISimpleFilter> filter;
                boolean passes;
                if (!(member instanceof ISortingInventory) || !(passes = (filter = (memberInventory = (ISortingInventory)member).getFilter()).filter(arg_0 -> InternalMethodsImpl.lambda$insertIntoSortingGrid$0(memberInventory, testStack = restStack, arg_0)).isPresent())) continue;
                passingList.add(memberInventory);
            }
        }
        if (!passingList.isEmpty() && (targetInventory = InternalMethodsImpl.getBestTargetInventory(passingList, null)) != sortingInventory) {
            while (!restStack.func_190926_b() && !passingList.isEmpty() && targetInventory != null) {
                ItemStack movedStack;
                int actuallyInserted;
                int insertCount = restStack.func_190916_E();
                IItemHandler targetItemHandler = RefinedRelocationUtils.orNull(targetInventory.getItemHandler());
                if (targetItemHandler != null) {
                    restStack = ItemHandlerHelper.insertItemStacked((IItemHandler)targetItemHandler, (ItemStack)restStack, (boolean)false);
                }
                if ((actuallyInserted = insertCount - restStack.func_190916_E()) > 0 && (movedStack = itemHandler.extractItem(fromSlotIndex, actuallyInserted, false)).func_190916_E() != actuallyInserted) {
                    throw new RuntimeException("Refined Relocation ran into a major problem with the connected inventory " + sortingInventory + ". Please report this at https://github.com/blay09/RefinedRelocation2/issues.");
                }
                if (restStack.func_190926_b()) continue;
                targetInventory = InternalMethodsImpl.getBestTargetInventory(passingList, targetInventory);
            }
        }
    }

    @Nullable
    private static ISortingInventory getBestTargetInventory(List<ISortingInventory> passingList, @Nullable ISortingInventory lastInventory) {
        ISortingInventory targetInventory = null;
        int highestPriority = Integer.MIN_VALUE;
        Iterator<ISortingInventory> it = passingList.iterator();
        while (it.hasNext()) {
            ISortingInventory sortingInventory = it.next();
            if (sortingInventory == lastInventory) {
                it.remove();
                continue;
            }
            if (sortingInventory.getPriority() <= highestPriority) continue;
            targetInventory = sortingInventory;
            highestPriority = sortingInventory.getPriority();
        }
        return targetInventory;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Button createOpenFilterButton(ContainerScreen<?> guiContainer, TileEntity tileEntity, int rootFilterIndex) {
        return new GuiOpenFilterButton(guiContainer.getGuiLeft() + guiContainer.getXSize() - 18, guiContainer.getGuiTop() + 4, tileEntity, rootFilterIndex);
    }

    @Override
    public void sendContainerMessageToServer(String key, String value) {
        NetworkHandler.channel.sendToServer((Object)new MessageContainerString(key, value));
    }

    @Override
    public void sendContainerMessageToServer(String key, CompoundNBT value) {
        NetworkHandler.channel.sendToServer((Object)new MessageContainerNBT(key, value));
    }

    @Override
    public void sendContainerMessageToServer(String key, int value) {
        NetworkHandler.channel.sendToServer((Object)new MessageContainerInt(key, value));
    }

    @Override
    public void sendContainerMessageToServer(String key, int value, int secondaryValue) {
        NetworkHandler.channel.sendToServer((Object)new MessageContainerIndexedInt(key, value, secondaryValue));
    }

    @Override
    public void syncContainerValue(String key, String value, Iterable<IContainerListener> listeners) {
        this.syncContainerValue(new MessageContainerString(key, value), listeners);
    }

    @Override
    public void syncContainerValue(String key, int value, Iterable<IContainerListener> listeners) {
        this.syncContainerValue(new MessageContainerInt(key, value), listeners);
    }

    @Override
    public void syncContainerValue(String key, byte[] value, Iterable<IContainerListener> listeners) {
        this.syncContainerValue(new MessageContainerByteArray(key, value), listeners);
    }

    @Override
    public void syncContainerValue(String key, CompoundNBT value, Iterable<IContainerListener> listeners) {
        this.syncContainerValue(new MessageContainerNBT(key, value), listeners);
    }

    private void syncContainerValue(MessageContainer message, Iterable<IContainerListener> listeners) {
        for (IContainerListener listener : listeners) {
            if (!(listener instanceof ServerPlayerEntity)) continue;
            NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)listener), (Object)message);
        }
    }

    @Override
    public void openRootFilterGui(PlayerEntity player, TileEntity tileEntity, int rootFilterIndex) {
        if (player.field_70170_p.field_72995_K) {
            NetworkHandler.channel.sendToServer((Object)new MessageRequestFilterGUI(tileEntity.func_174877_v(), rootFilterIndex));
        } else {
            RefinedRelocationUtils.getRootFilter(tileEntity, rootFilterIndex).ifPresent(rootFilter -> {
                INamedContainerProvider filterConfig = rootFilter.getConfiguration(player, tileEntity, rootFilterIndex);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)filterConfig, (BlockPos)tileEntity.func_174877_v());
            });
        }
    }

    @Override
    public void updateFilterPreview(PlayerEntity entityPlayer, TileEntity tileEntity, ISimpleFilter filter) {
        if (!entityPlayer.field_70170_p.field_72995_K) {
            byte[] slotStates = new byte[36];
            for (int i = 0; i < slotStates.length; ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (itemStack.func_190926_b()) continue;
                slotStates[i] = (byte)(filter.passes(tileEntity, itemStack) ? 1 : 0);
            }
            NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entityPlayer), (Object)new MessageFilterPreview(slotStates));
        }
    }

    @Override
    public void returnToParentContainer() {
        NetworkHandler.channel.sendToServer((Object)new MessageReturnGUI());
    }

    private static /* synthetic */ boolean lambda$insertIntoSortingGrid$0(ISortingInventory memberInventory, ItemStack testStack, ISimpleFilter it) {
        return it.passes(memberInventory.getTileEntity(), testStack);
    }
}

