/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import java.util.Random;
import net.minecraft.util.math.Vec3d;

public class MathUtil {
    public static final Random RANDOM = new Random();

    public static Vec3d rotateVectorAroundYCC(Vec3d vec, double angle) {
        return MathUtil.rotateVectorCC(vec, new Vec3d(0.0, 1.0, 0.0), angle);
    }

    public static Vec3d rotateVectorCC(Vec3d vec, Vec3d axis, double angle) {
        double x = vec.func_82615_a();
        double y = vec.func_82617_b();
        double z = vec.func_82616_c();
        double u = axis.func_82615_a();
        double v = axis.func_82617_b();
        double w = axis.func_82616_c();
        double rotationX = u * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + x * Math.cos(angle) + (-w * y + v * z) * Math.sin(angle);
        double rotationY = v * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + y * Math.cos(angle) + (w * x - u * z) * Math.sin(angle);
        double rotationZ = w * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + z * Math.cos(angle) + (-v * x + u * y) * Math.sin(angle);
        return new Vec3d(rotationX, rotationY, rotationZ);
    }

    public static int getRandomNumberInRange(int min, int max) {
        return MathUtil.getRandomNumberInRange(RANDOM, min, max);
    }

    public static int getRandomNumberInRange(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float getRandomNumberInRange(float min, float max) {
        return MathUtil.getRandomNumberInRange(RANDOM, min, max);
    }

    public static float getRandomNumberInRange(Random random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double getRandomNumberInRange(double min, double max) {
        return MathUtil.getRandomNumberInRange(RANDOM, min, max);
    }

    public static double getRandomNumberInRange(Random random, double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }
}

