/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.util.GuiUtil;
import java.util.ArrayList;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class EnergyStorageWidget
extends Widget {
    public static final ResourceLocation ENERGY_TEXTURE = new ResourceLocation("uteamcore", "textures/gui/energy.png");
    private final LongSupplier capacity;
    private final LongSupplier storage;

    public EnergyStorageWidget(int x, int y, int height, LazyOptional<IEnergyStorage> energyStorage) {
        this(x, y, height, () -> ((Integer)energyStorage.map(IEnergyStorage::getMaxEnergyStored).orElse((Object)0)).intValue(), () -> ((Integer)energyStorage.map(IEnergyStorage::getEnergyStored).orElse((Object)0)).intValue());
    }

    public EnergyStorageWidget(int x, int y, int height, Supplier<IEnergyStorage> energyStorage) {
        this(x, y, height, () -> ((IEnergyStorage)energyStorage.get()).getMaxEnergyStored(), () -> ((IEnergyStorage)energyStorage.get()).getEnergyStored());
    }

    public EnergyStorageWidget(int x, int y, int height, LongSupplier capacity, LongSupplier storage) {
        super(x, y, 14, height < 3 ? 3 : height, "");
        this.capacity = capacity;
        this.storage = storage;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        int yComponent;
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(ENERGY_TEXTURE);
        double ratio = (double)this.storage.getAsLong() / (double)this.capacity.getAsLong();
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        int storageOffset = (int)((1.0 - ratio) * (double)(this.height - 2));
        for (yComponent = 1; yComponent < this.height - 1; yComponent += 2) {
            EnergyStorageWidget.blit((int)(this.x + 1), (int)(this.y + yComponent), (float)0.0f, (float)0.0f, (int)12, (int)2, (int)16, (int)16);
        }
        for (yComponent = 1 + storageOffset; yComponent < this.height - 1; ++yComponent) {
            if (yComponent % 2 == 0) {
                EnergyStorageWidget.blit((int)(this.x + 1), (int)(this.y + yComponent), (float)0.0f, (float)3.0f, (int)12, (int)1, (int)16, (int)16);
                continue;
            }
            EnergyStorageWidget.blit((int)(this.x + 1), (int)(this.y + yComponent), (float)0.0f, (float)2.0f, (int)12, (int)1, (int)16, (int)16);
        }
        GuiUtil.drawContainerBorder(this.x, this.y, this.width, this.height);
    }

    public void renderToolTip(int mouseX, int mouseY) {
        if (this.isHovered) {
            Minecraft minecraft = Minecraft.func_71410_x();
            MainWindow mainWindow = minecraft.func_228018_at_();
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.storage.getAsLong() + " / " + this.capacity.getAsLong() + " FE");
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)mainWindow.func_198105_m(), (int)mainWindow.func_198083_n(), (int)300, (FontRenderer)minecraft.field_71466_p);
        }
    }

    public void playDownSound(SoundHandler handler) {
    }
}

