/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockCategories {
    private static final String MODID = "rsgauges";
    private static final Matcher filter_none = (w, p) -> false;
    private static final Map<String, Matcher> matchers_ = new HashMap<String, Matcher>();
    private static final List<String> matcher_names_;

    public static final void update() {
    }

    public static final Matcher getMatcher(String name) {
        return matchers_.getOrDefault(name, filter_none);
    }

    public static final List<String> getMatcherNames() {
        return matcher_names_;
    }

    static {
        matchers_.put("any", (w, p) -> {
            BlockState st = w.func_180495_p(p);
            return !st.func_177230_c().isAir(st, (IBlockReader)w, p);
        });
        matchers_.put("solid", (w, p) -> w.func_180495_p(p).func_185904_a().func_76220_a());
        matchers_.put("liquid", (w, p) -> w.func_180495_p(p).func_185904_a().func_76224_d() || !w.func_204610_c(p).func_206888_e());
        matchers_.put("air", (w, p) -> {
            BlockState st = w.func_180495_p(p);
            return st.func_177230_c().isAir(st, (IBlockReader)w, p);
        });
        matchers_.put("plant", (w, p) -> {
            Block b = w.func_180495_p(p).func_177230_c();
            return b instanceof IGrowable || b instanceof IPlantable || b.getTags().contains(new ResourceLocation(MODID, "plants"));
        });
        matchers_.put("material_wood", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "wooden")));
        matchers_.put("material_stone", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "stone_like")));
        matchers_.put("material_glass", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "glass_like")));
        matchers_.put("material_clay", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "clay_like")));
        matchers_.put("material_water", (w, p) -> {
            BlockState st = w.func_180495_p(p);
            Block b = st.func_177230_c();
            if (b.getTags().contains(new ResourceLocation(MODID, "water_like"))) {
                return true;
            }
            if (st.func_204520_s().func_206888_e()) {
                return false;
            }
            return st.func_204520_s().func_206886_c() == Fluids.field_204546_a || st.func_204520_s().func_206886_c() == Fluids.field_207212_b;
        });
        matchers_.put("ore", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "ores")));
        matchers_.put("woodlog", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "logs")));
        matchers_.put("crop", (w, p) -> {
            Block b = w.func_180495_p(p).func_177230_c();
            return b instanceof CropsBlock || b.getTags().contains(new ResourceLocation(MODID, "crops"));
        });
        matchers_.put("crop_mature", (w, p) -> {
            BlockState s = w.func_180495_p(p);
            Block b = s.func_177230_c();
            return b instanceof CropsBlock && ((CropsBlock)b).func_185525_y(s) || b == Blocks.field_150440_ba || b == Blocks.field_150423_aK;
        });
        matchers_.put("sapling", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "saplings")));
        matchers_.put("soil", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "soils")));
        matchers_.put("fertile", (w, p) -> w.func_180495_p(p).func_177230_c().isFertile(w.func_180495_p(p), (IBlockReader)w, p));
        matchers_.put("planks", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "planks")));
        matchers_.put("slab", (w, p) -> w.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation(MODID, "slabs")));
        matcher_names_ = new ArrayList<String>();
        matcher_names_.add("any");
        matcher_names_.add("solid");
        matcher_names_.add("liquid");
        matcher_names_.add("air");
        matcher_names_.add("plant");
        matcher_names_.add("material_wood");
        matcher_names_.add("material_stone");
        matcher_names_.add("material_glass");
        matcher_names_.add("material_clay");
        matcher_names_.add("material_water");
        matcher_names_.add("ore");
        matcher_names_.add("woodlog");
        matcher_names_.add("crop");
        matcher_names_.add("crop_mature");
        matcher_names_.add("sapling");
        matcher_names_.add("soil");
        matcher_names_.add("fertile");
        matcher_names_.add("planks");
        matcher_names_.add("slab");
        matchers_.forEach((k, v) -> {
            if (!matcher_names_.contains(k)) {
                matcher_names_.add((String)k);
            }
        });
    }

    public static interface Matcher {
        public boolean match(World var1, BlockPos var2);
    }
}

