/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.ToolsLang;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class ItemMekanismShovel
extends ShovelItem
implements IHasRepairType {
    private final BaseMekanismMaterial material;

    public ItemMekanismShovel(BaseMekanismMaterial material) {
        super((IItemTier)material, material.getShovelDamage(), material.getShovelAtkSpeed(), ItemDeferredRegister.getMekBaseProperties());
        this.material = material;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)ToolsLang.HP.translate(new Object[]{stack.func_77958_k() - stack.func_77952_i()}));
    }

    public float getAttackDamage() {
        return this.material.getShovelDamage() + this.func_200891_e().func_200929_c();
    }

    public int getHarvestLevel() {
        return this.func_200891_e().func_200925_d();
    }

    public float func_150893_a(@Nonnull ItemStack stack, BlockState state) {
        return this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) || this.field_150914_c.contains(state.func_177230_c()) ? this.func_200891_e().func_200928_b() : 1.0f;
    }

    public boolean func_150897_b(BlockState state) {
        return state.getHarvestTool() == ToolType.SHOVEL ? this.getHarvestLevel() >= state.getHarvestLevel() : super.func_150897_b(state);
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.func_200891_e().func_200924_f();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.func_200891_e().func_200926_a();
    }

    public boolean func_77645_m() {
        return this.func_200891_e().func_200926_a() > 0;
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return tool == ToolType.SHOVEL ? this.getHarvestLevel() : super.getHarvestLevel(stack, tool, player, blockState);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType slot) {
        HashMultimap attributes = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getAttackDamage(), AttributeModifier.Operation.ADDITION));
            attributes.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.material.getShovelAtkSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return attributes;
    }
}

