/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableGasStack;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineCache;
import mekanism.generators.common.content.turbine.TurbineUpdateProtocol;
import mekanism.generators.common.registries.GeneratorsBlocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityTurbineCasing
extends TileEntityMultiblock<SynchronizedTurbineData>
implements IHasGasMode {
    public float prevSteamScale;

    public TileEntityTurbineCasing() {
        this((IBlockProvider)GeneratorsBlocks.TURBINE_CASING);
    }

    public TileEntityTurbineCasing(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.structure != null && this.isRendering) {
            float scale;
            ((SynchronizedTurbineData)this.structure).lastSteamInput = ((SynchronizedTurbineData)this.structure).newSteamInput;
            ((SynchronizedTurbineData)this.structure).newSteamInput = 0L;
            long stored = ((SynchronizedTurbineData)this.structure).gasTank.getStored();
            double flowRate = 0.0;
            FloatingLong energyNeeded = ((SynchronizedTurbineData)this.structure).energyContainer.getNeeded();
            if (stored > 0L && !energyNeeded.isZero()) {
                FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(((SynchronizedTurbineData)this.structure).blades, ((SynchronizedTurbineData)this.structure).coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
                if (energyMultiplier.isZero()) {
                    ((SynchronizedTurbineData)this.structure).clientFlow = 0L;
                } else {
                    double rate = (double)((SynchronizedTurbineData)this.structure).lowerVolume * ((double)((SynchronizedTurbineData)this.structure).getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
                    rate = Math.min(rate, (double)((SynchronizedTurbineData)this.structure).vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
                    double proportion = (double)stored / (double)((SynchronizedTurbineData)this.structure).getSteamCapacity();
                    double origRate = rate;
                    rate = Math.min(Math.min((double)stored, rate), energyNeeded.divide(energyMultiplier).doubleValue()) * proportion;
                    flowRate = rate / origRate;
                    ((SynchronizedTurbineData)this.structure).energyContainer.insert(energyMultiplier.multiply(rate), Action.EXECUTE, AutomationType.INTERNAL);
                    if (!((SynchronizedTurbineData)this.structure).gasTank.isEmpty()) {
                        ((SynchronizedTurbineData)this.structure).gasTank.shrinkStack((long)rate, Action.EXECUTE);
                    }
                    ((SynchronizedTurbineData)this.structure).clientFlow = (long)rate;
                    ((SynchronizedTurbineData)this.structure).ventTank.setStack(new FluidStack((Fluid)Fluids.field_204546_a, Math.min(MathUtils.clampToInt((double)rate), ((SynchronizedTurbineData)this.structure).condensers * MekanismGeneratorsConfig.generators.condenserRate.get())));
                }
            } else {
                ((SynchronizedTurbineData)this.structure).clientFlow = 0L;
            }
            if (((SynchronizedTurbineData)this.structure).dumpMode == TileEntityGasTank.GasMode.DUMPING && !((SynchronizedTurbineData)this.structure).gasTank.isEmpty()) {
                long amount = ((SynchronizedTurbineData)this.structure).gasTank.getStored();
                ((SynchronizedTurbineData)this.structure).gasTank.shrinkStack(Math.min(amount, Math.max(amount / 50L, ((SynchronizedTurbineData)this.structure).lastSteamInput * 2L)), Action.EXECUTE);
            }
            float newRotation = (float)flowRate;
            boolean needsPacket = false;
            if (Math.abs(newRotation - ((SynchronizedTurbineData)this.structure).clientRotation) > 0.001f) {
                ((SynchronizedTurbineData)this.structure).clientRotation = newRotation;
                needsPacket = true;
            }
            if ((scale = MekanismUtils.getScale((float)this.prevSteamScale, ((SynchronizedTurbineData)this.structure).gasTank)) != this.prevSteamScale) {
                needsPacket = true;
                this.prevSteamScale = scale;
            }
            if (needsPacket) {
                this.sendUpdatePacket();
            }
        }
    }

    public void nextMode(int tank) {
        if (tank == 0 && this.structure != null) {
            ((SynchronizedTurbineData)this.structure).dumpMode = (TileEntityGasTank.GasMode)((SynchronizedTurbineData)this.structure).dumpMode.getNext();
        }
    }

    @Nonnull
    protected SynchronizedTurbineData getNewStructure() {
        return new SynchronizedTurbineData(this);
    }

    public MultiblockCache<SynchronizedTurbineData> getNewCache() {
        return new TurbineCache();
    }

    protected UpdateProtocol<SynchronizedTurbineData> getProtocol() {
        return new TurbineUpdateProtocol(this);
    }

    public MultiblockManager<SynchronizedTurbineData> getManager() {
        return MekanismGenerators.turbineManager;
    }

    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        if (this.structure != null && this.isRendering) {
            updateTag.func_74776_a("scale", this.prevSteamScale);
            updateTag.func_74768_a("volume", ((SynchronizedTurbineData)this.structure).getVolume());
            updateTag.func_74768_a("lowerVolume", ((SynchronizedTurbineData)this.structure).lowerVolume);
            updateTag.func_218657_a("gas", (INBT)((GasStack)((SynchronizedTurbineData)this.structure).gasTank.getStack()).write(new CompoundNBT()));
            updateTag.func_218657_a("complex", (INBT)((SynchronizedTurbineData)this.structure).complex.write(new CompoundNBT()));
            updateTag.func_74776_a("rotation", ((SynchronizedTurbineData)this.structure).clientRotation);
        }
        return updateTag;
    }

    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        if (this.clientHasStructure && this.isRendering && this.structure != null) {
            NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"scale", scale -> {
                this.prevSteamScale = scale;
            });
            NBTUtils.setIntIfPresent((CompoundNBT)tag, (String)"volume", value -> ((SynchronizedTurbineData)this.structure).setVolume(value));
            NBTUtils.setIntIfPresent((CompoundNBT)tag, (String)"lowerVolume", value -> {
                ((SynchronizedTurbineData)this.structure).lowerVolume = value;
            });
            NBTUtils.setGasStackIfPresent((CompoundNBT)tag, (String)"gas", value -> ((SynchronizedTurbineData)this.structure).gasTank.setStack((ChemicalStack)value));
            NBTUtils.setCoord4DIfPresent((CompoundNBT)tag, (String)"complex", value -> {
                ((SynchronizedTurbineData)this.structure).complex = value;
            });
            NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"rotation", value -> {
                ((SynchronizedTurbineData)this.structure).clientRotation = value;
            });
            SynchronizedTurbineData.clientRotationMap.put((Object)((SynchronizedTurbineData)this.structure).inventoryID, ((SynchronizedTurbineData)this.structure).clientRotation);
        }
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedTurbineData)this.structure).getVolume(), value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).setVolume(value);
            }
        }));
        container.track((ISyncableData)SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedTurbineData)this.structure).lowerVolume, value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).lowerVolume = value;
            }
        }));
        container.track((ISyncableData)SyncableGasStack.create(() -> this.structure == null ? GasStack.EMPTY : (GasStack)((SynchronizedTurbineData)this.structure).gasTank.getStack(), value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).gasTank.setStack((ChemicalStack)value);
            }
        }));
        container.track((ISyncableData)SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedTurbineData)this.structure).vents, value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).vents = value;
            }
        }));
        container.track((ISyncableData)SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedTurbineData)this.structure).blades, value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).blades = value;
            }
        }));
        container.track((ISyncableData)SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedTurbineData)this.structure).coils, value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).coils = value;
            }
        }));
        container.track((ISyncableData)SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedTurbineData)this.structure).condensers, value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).condensers = value;
            }
        }));
        container.track((ISyncableData)SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedTurbineData)this.structure).getDispersers(), value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).clientDispersers = value;
            }
        }));
        container.track((ISyncableData)SyncableFloatingLong.create(() -> this.structure == null ? FloatingLong.ZERO : ((SynchronizedTurbineData)this.structure).energyContainer.getEnergy(), value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).energyContainer.setEnergy(value);
            }
        }));
        container.track((ISyncableData)SyncableLong.create(() -> this.structure == null ? 0L : ((SynchronizedTurbineData)this.structure).clientFlow, value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).clientFlow = value;
            }
        }));
        container.track((ISyncableData)SyncableLong.create(() -> this.structure == null ? 0L : ((SynchronizedTurbineData)this.structure).lastSteamInput, value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).lastSteamInput = value;
            }
        }));
        container.track((ISyncableData)SyncableEnum.create(TileEntityGasTank.GasMode::byIndexStatic, (Enum)TileEntityGasTank.GasMode.IDLE, () -> this.structure == null ? TileEntityGasTank.GasMode.IDLE : ((SynchronizedTurbineData)this.structure).dumpMode, value -> {
            if (this.structure != null) {
                ((SynchronizedTurbineData)this.structure).dumpMode = value;
            }
        }));
    }
}

