/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;

public class RetextureableBlockModelWrapper
extends BlockModel {
    private final BlockModel model;

    public RetextureableBlockModelWrapper(BlockModel model) {
        super(model.getParentLocation(), model.func_178298_a(), model.field_178318_c, model.field_178322_i, model.func_230176_c_(), model.func_181682_g(), model.func_187966_f());
        this.model = model;
        this.field_178317_b = model.field_178317_b;
        this.field_178315_d = model.field_178315_d;
    }

    public RetextureableBlockModelWrapper retexture(ImmutableMap<String, String> textures) {
        if (textures.isEmpty()) {
            return this;
        }
        ArrayList elements = Lists.newArrayList();
        for (BlockPart part : this.model.func_178298_a()) {
            elements.add(new BlockPart(part.field_178241_a, part.field_178239_b, (Map)Maps.newHashMap((Map)part.field_178240_c), part.field_178237_d, part.field_178238_e));
        }
        BlockModel newModel = new BlockModel(this.model.getParentLocation(), (List)elements, (Map)Maps.newHashMap((Map)this.model.field_178318_c), this.model.func_178309_b(), this.model.func_230176_c_(), this.model.func_181682_g(), (List)Lists.newArrayList((Iterable)this.model.func_187966_f()));
        newModel.field_178317_b = this.model.field_178317_b;
        newModel.field_178315_d = this.model.field_178315_d;
        HashSet removed = Sets.newHashSet();
        for (Map.Entry e : textures.entrySet()) {
            if ("".equals(e.getValue())) {
                removed.add(e.getKey());
                newModel.field_178318_c.remove(e.getKey());
                continue;
            }
            newModel.field_178318_c.put(e.getKey(), Either.left((Object)new Material(AtlasTexture.field_110575_b, new ResourceLocation((String)e.getValue()))));
        }
        HashMap remapped = Maps.newHashMap();
        for (Map.Entry e : newModel.field_178318_c.entrySet()) {
            String key;
            Optional right = ((Either)e.getValue()).right();
            if (!right.isPresent() || !((String)right.get()).startsWith("#") || !newModel.field_178318_c.containsKey(key = ((String)right.get()).substring(1))) continue;
            remapped.put(e.getKey(), newModel.field_178318_c.get(key));
        }
        newModel.field_178318_c.putAll(remapped);
        for (BlockPart part : newModel.func_178298_a()) {
            part.field_178240_c.entrySet().removeIf(entry -> removed.contains(((BlockPartFace)entry.getValue()).field_178242_d));
        }
        return new RetextureableBlockModelWrapper(newModel);
    }
}

