/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidHandlerBlock
implements IFluidHandler {
    private final BlockState state;
    private final World world;
    private final BlockPos blockPos;

    public FluidHandlerBlock(BlockState state, World world, BlockPos blockPos) {
        this.state = state;
        this.world = world;
        this.blockPos = blockPos;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Block block = this.state.func_177230_c();
        if (block instanceof FlowingFluidBlock && (Integer)this.state.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0) {
            return new FluidStack((Fluid)((FlowingFluidBlock)block).getFluid(), 1000);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        Block block = this.state.func_177230_c();
        if (block instanceof FlowingFluidBlock && ((FlowingFluidBlock)block).getFluid() == resource.getFluid()) {
            return this.drain(resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Block block = this.state.func_177230_c();
        if (block instanceof FlowingFluidBlock && (Integer)this.state.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0 && maxDrain >= 1000) {
            if (action.execute()) {
                this.world.func_180501_a(this.blockPos, Blocks.field_150350_a.func_176223_P(), 11);
            }
            return new FluidStack((Fluid)((FlowingFluidBlock)block).getFluid(), 1000);
        }
        return FluidStack.EMPTY;
    }
}

