/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.block;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.block.BlockTile;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.flopper.block.BlockFlopperConfig;
import org.cyclops.flopper.tileentity.TileFlopper;

public class BlockFlopper
extends BlockTile {
    public static final DirectionProperty FACING = BlockStateProperties.field_208156_I;
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;

    public BlockFlopper(Block.Properties properties, Supplier<CyclopsTileEntity> tileEntitySupplier) {
        super(properties, tileEntitySupplier);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.DOWN)).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, ENABLED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Blocks.field_150438_bZ.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return Blocks.field_150438_bZ.func_199600_g(state, worldIn, pos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l().func_176734_d();
        if (direction == Direction.UP) {
            direction = Direction.DOWN;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)direction)).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            this.updateState(worldIn, pos, state);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.updateState(worldIn, pos, state);
    }

    private void updateState(World worldIn, BlockPos pos, BlockState state) {
        boolean notPowered;
        boolean bl = notPowered = !worldIn.func_175640_z(pos);
        if (notPowered != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(notPowered)), 4);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ActionResultType activatedSuper = super.func_225533_a_(blockState, world, blockPos, player, hand, rayTraceResult);
        if (activatedSuper.func_226246_a_()) {
            return activatedSuper;
        }
        return (ActionResultType)TileHelpers.getCapability((IBlockReader)world, (BlockPos)blockPos, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(fluidHandler -> {
            ItemStack itemStack = player.func_184586_b(hand);
            if (itemStack.func_190926_b()) {
                if (BlockFlopperConfig.showContentsStatusMessageOnClick) {
                    FluidStack fluidStack = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    if (fluidStack.isEmpty()) {
                        player.func_146105_b((ITextComponent)new StringTextComponent("0 / " + String.format("%,d", fluidHandler.getTankCapacity(0))), true);
                    } else {
                        player.func_146105_b(new TranslationTextComponent(fluidStack.getTranslationKey(), new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(": " + String.format("%,d", fluidStack.getAmount()) + " / " + String.format("%,d", fluidHandler.getTankCapacity(0)))), true);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (!player.func_213453_ef() && BlockFlopper.tryEmptyContainer(itemStack, fluidHandler, 1000, player, false).isSuccess()) {
                    ItemStack drainedItem = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)fluidHandler, (int)1000, (PlayerEntity)player, (boolean)true).getResult();
                    if (!player.func_184812_l_()) {
                        InventoryHelpers.tryReAddToStack((PlayerEntity)player, (ItemStack)itemStack, (ItemStack)drainedItem);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (player.func_213453_ef() && FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)fluidHandler, (int)1000, (PlayerEntity)player, (boolean)false).isSuccess()) {
                    FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)fluidHandler, (int)1000, (PlayerEntity)player, (boolean)true);
                    if (result.isSuccess()) {
                        ItemStack filledItem = result.getResult();
                        if (!player.func_184812_l_()) {
                            InventoryHelpers.tryReAddToStack((PlayerEntity)player, (ItemStack)itemStack, (ItemStack)filledItem);
                        }
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.PASS;
        }).orElse((Object)ActionResultType.PASS);
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable PlayerEntity player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return (FluidActionResult)FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (doDrain && player != null) {
                SoundEvent soundevent = transfer.getFluid().getAttributes().getEmptySound(transfer);
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse((Object)FluidActionResult.FAILURE);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return TileHelpers.getSafeTile((IBlockReader)worldIn, (BlockPos)pos, TileFlopper.class).map(tile -> tile.getTank().getFluidAmount() * 8 / tile.getTank().getCapacity()).orElse(0);
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().func_190926_b() && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == this && event.getItemStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }
}

