/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage;

import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

public class StorageEntry {
    private NonNullList<ItemStack> stacks;
    private final UUID uuid;
    private int version;
    private long creationTime;
    private long updateTime;
    private String createdBy;

    public StorageEntry(CompoundNBT nbt) {
        int size = nbt.func_74762_e("slots");
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTags));
        }
        this.uuid = nbt.func_186857_a("UUID");
        this.version = nbt.func_74762_e("version");
        this.creationTime = nbt.func_74763_f("crTime");
        this.updateTime = nbt.func_74763_f("upTime");
        this.createdBy = nbt.func_74779_i("createdBy");
    }

    public StorageEntry(int size, UUID uuid, String createdBy) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.uuid = uuid;
        this.version = 1;
        this.creationTime = this.updateTime = System.currentTimeMillis();
        this.createdBy = createdBy == null ? "" : createdBy;
    }

    public int getVersion() {
        return this.version;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void updateVersion() {
        ++this.version;
        this.updateTime = System.currentTimeMillis();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("slots", this.stacks.size());
        nbt.func_74768_a("version", this.version);
        nbt.func_74772_a("crTime", this.creationTime);
        nbt.func_74772_a("upTime", this.updateTime);
        nbt.func_74778_a("createdBy", this.createdBy);
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", i);
            ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        nbt.func_186854_a("UUID", this.uuid);
        return nbt;
    }

    public void resize(int size, String createdBy) {
        NonNullList<ItemStack> oldList = this.stacks;
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < Math.min(oldList.size(), size); ++i) {
            this.stacks.set(i, oldList.get(i));
        }
        this.updateTime = System.currentTimeMillis();
        if (createdBy != null && !createdBy.isEmpty()) {
            this.createdBy = createdBy;
        }
    }
}

