/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.rftoolsstorage.modules.scanner.client.GuiStorageScanner;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketReturnInventoryInfo {
    private List<InventoryInfo> inventories;

    public List<InventoryInfo> getInventories() {
        return this.inventories;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.inventories.size());
        for (InventoryInfo info : this.inventories) {
            buf.func_179255_a(info.getPos());
            buf.func_180714_a(info.getName());
            buf.writeBoolean(info.isRoutable());
            if (info.getBlock() == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            String id = info.getBlock().getRegistryName().toString();
            buf.func_180714_a(id);
        }
    }

    public PacketReturnInventoryInfo() {
    }

    public PacketReturnInventoryInfo(PacketBuffer buf) {
        int size = buf.readInt();
        this.inventories = new ArrayList<InventoryInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buf.func_179259_c();
            String name = buf.func_150789_c(Short.MAX_VALUE);
            boolean routable = buf.readBoolean();
            Block block = null;
            if (buf.readBoolean()) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
            }
            this.inventories.add(new InventoryInfo(pos, name, routable, block));
        }
    }

    public PacketReturnInventoryInfo(List<InventoryInfo> inventories) {
        this.inventories = inventories;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            GuiStorageScanner.fromServer_inventories = this.getInventories();
        });
        ctx.setPacketHandled(true);
    }

    public static class InventoryInfo {
        private final BlockPos pos;
        private final String name;
        private final boolean routable;
        private final Block block;

        public InventoryInfo(BlockPos pos, String name, boolean routable, Block block) {
            this.pos = pos;
            this.name = name;
            this.routable = routable;
            this.block = block;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRoutable() {
            return this.routable;
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

