/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRequestItem {
    private DimensionType dimensionId;
    private BlockPos pos;
    private BlockPos inventoryPos;
    private ItemStack item;
    private int amount;
    private boolean craftable;

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.dimensionId.func_186068_a());
        buf.func_179255_a(this.pos);
        buf.func_179255_a(this.inventoryPos);
        buf.writeInt(this.amount);
        NetworkTools.writeItemStack((PacketBuffer)buf, (ItemStack)this.item);
        buf.writeBoolean(this.craftable);
    }

    public PacketRequestItem() {
    }

    public PacketRequestItem(PacketBuffer buf) {
        this.dimensionId = DimensionType.func_186069_a((int)buf.readInt());
        this.pos = buf.func_179259_c();
        this.inventoryPos = buf.func_179259_c();
        this.amount = buf.readInt();
        this.item = NetworkTools.readItemStack((PacketBuffer)buf);
        this.craftable = buf.readBoolean();
    }

    public PacketRequestItem(DimensionType dimensionId, BlockPos pos, BlockPos inventoryPos, ItemStack item, int amount, boolean craftable) {
        this.dimensionId = dimensionId;
        this.pos = pos;
        this.inventoryPos = inventoryPos;
        this.item = item;
        this.amount = amount;
        this.craftable = craftable;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerWorld world = WorldTools.getWorld((World)ctx.getSender().field_70170_p, (DimensionType)this.dimensionId);
            if (world == null) {
                return;
            }
            if (!WorldTools.isLoaded((World)world, (BlockPos)this.pos)) {
                return;
            }
            TileEntity te = world.func_175625_s(this.pos);
            if (te instanceof StorageScannerTileEntity) {
                StorageScannerTileEntity tileEntity = (StorageScannerTileEntity)te;
                if (this.craftable) {
                    tileEntity.requestCraft(this.inventoryPos, this.item, this.amount, (PlayerEntity)ctx.getSender());
                } else {
                    tileEntity.requestStack(this.inventoryPos, this.item, this.amount, (PlayerEntity)ctx.getSender());
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

