/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.network.PacketReturnInventoryInfo;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class PacketGetInventoryInfo {
    private DimensionType id;
    private BlockPos pos;
    private boolean doscan;

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.id.func_186068_a());
        buf.writeBoolean(this.doscan);
    }

    public PacketGetInventoryInfo() {
    }

    public PacketGetInventoryInfo(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.id = DimensionType.func_186069_a((int)buf.readInt());
        this.doscan = buf.readBoolean();
    }

    public PacketGetInventoryInfo(DimensionType worldId, BlockPos pos, boolean doscan) {
        this.id = worldId;
        this.pos = pos;
        this.doscan = doscan;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> this.onMessageServer((PlayerEntity)ctx.getSender()).ifPresent(p -> this.sendReplyToClient((List<PacketReturnInventoryInfo.InventoryInfo>)p, ctx.getSender())));
        ctx.setPacketHandled(true);
    }

    private void sendReplyToClient(List<PacketReturnInventoryInfo.InventoryInfo> reply, ServerPlayerEntity player) {
        PacketReturnInventoryInfo msg = new PacketReturnInventoryInfo(reply);
        RFToolsStorageMessages.INSTANCE.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    private Optional<List<PacketReturnInventoryInfo.InventoryInfo>> onMessageServer(PlayerEntity entityPlayerMP) {
        ServerWorld world = WorldTools.getWorld((World)entityPlayerMP.field_70170_p, (DimensionType)this.id);
        if (world == null) {
            return Optional.empty();
        }
        if (!WorldTools.isLoaded((World)world, (BlockPos)this.pos)) {
            return Optional.empty();
        }
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scannerTileEntity = (StorageScannerTileEntity)te;
            Stream<BlockPos> inventories = this.doscan ? scannerTileEntity.findInventories() : scannerTileEntity.getAllInventories();
            List invs = inventories.map(arg_0 -> PacketGetInventoryInfo.lambda$onMessageServer$2((World)world, scannerTileEntity, arg_0)).collect(Collectors.toList());
            return Optional.of(invs);
        }
        return Optional.empty();
    }

    private static PacketReturnInventoryInfo.InventoryInfo toInventoryInfo(World world, BlockPos pos, StorageScannerTileEntity te) {
        String displayName;
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!WorldTools.isLoaded((World)world, (BlockPos)pos)) {
            displayName = "[UNLOADED]";
            block = null;
        } else if (world.func_175623_d(pos)) {
            displayName = "[REMOVED]";
            block = null;
        } else {
            displayName = BlockTools.getReadableName((World)world, (BlockPos)pos);
            TileEntity storageTe = world.func_175625_s(pos);
            if (storageTe instanceof ModularStorageTileEntity) {
                ModularStorageTileEntity storageTileEntity = (ModularStorageTileEntity)storageTe;
                String finalDisplayName = displayName;
                displayName = (String)storageTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> {
                    ItemStack storageModule = h.getStackInSlot(0);
                    if (!storageModule.func_190926_b() && storageModule.func_77942_o() && storageModule.func_77978_p().func_74764_b("display")) {
                        return storageModule.func_200301_q().func_150254_d();
                    }
                    return finalDisplayName;
                }).orElse((Object)displayName);
            }
        }
        return new PacketReturnInventoryInfo.InventoryInfo(pos, displayName, te.isRoutable(pos), block);
    }

    private static /* synthetic */ PacketReturnInventoryInfo.InventoryInfo lambda$onMessageServer$2(World world, StorageScannerTileEntity scannerTileEntity, BlockPos pos) {
        return PacketGetInventoryInfo.toInventoryInfo(world, pos, scannerTileEntity);
    }
}

